/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.ptn.common.components.configtoolbar.api;

import com.sap.caf.ui.ptn.common.components.configtoolbar.api.IConfigurationToolbarContext;
import com.sap.tc.webdynpro.basesrvc.util.StringUtil;
import com.sap.tc.webdynpro.progmodel.api.IWDComponent;
import com.sap.tc.webdynpro.services.sal.url.api.WDURLException;
import com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator;
import com.sap.tc.webdynpro.services.session.api.IWDWindow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultToolbarContext
implements IConfigurationToolbarContext {
    final IWDComponent _component;
    final String _appName;
    final String _appConfigParamName;
    final boolean _showHeader;
    final boolean _showMessageArea;
    final IAction _createAction;
    final IAction _resetAction;
    private List _buttons;

    public DefaultToolbarContext(IWDComponent component, IAction createAction, IAction resetAction, String appName, String appConfigParamName, boolean showHeader, boolean showMessageArea) {
        this._component = component;
        this._createAction = createAction;
        this._resetAction = resetAction;
        this._appName = appName;
        this._appConfigParamName = appConfigParamName;
        this._showHeader = showHeader;
        this._showMessageArea = showMessageArea;
        this._buttons = new ArrayList();
    }

    public boolean isPreviewAvailable() {
        return !StringUtil.isEmpty((String)this._appName);
    }

    public void preview(String configName) {
        String url;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(this._appConfigParamName, configName);
        try {
            url = WDURLGenerator.getApplicationURL((String)this._component.getDeployableObjectPart().getDeployableObjectName(), (String)this._appName, params);
        }
        catch (WDURLException exOnGenerateUrl) {
            this._component.getMessageManager().reportException(exOnGenerateUrl.getLocalizedMessage(), true);
            return;
        }
        IWDWindow previewWindow = this._component.getWindowManager().createExternalWindow(url, "", false);
        previewWindow.open();
    }

    public boolean isHeaderVisible() {
        return this._showHeader;
    }

    public boolean showMessageArea() {
        return this._showMessageArea;
    }

    public List toolbarButtons() {
        return this._buttons;
    }

    public void fireToolbarButtonPressed(String id) {
    }

    public void create() {
        this._createAction.execute();
    }

    public void reset() {
        this._resetAction.execute();
    }

    public static interface IAction {
        public void execute();
    }
}

