/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.ptn.common.components.configtoolbar.api;

import com.sap.caf.ui.ptn.common.components.componentbrowser.api.ICBConfigurationSearcher;
import com.sap.caf.ui.ptn.common.components.configtoolbar.api.DefaultToolbarContext;
import com.sap.caf.ui.ptn.common.components.configtoolbar.api.IConfigurationToolbarContext;
import com.sap.caf.ui.utils.repository.IConfigurationManager;
import com.sap.caf.ui.utils.repository.ReposUtils;
import com.sap.tc.webdynpro.basesrvc.util.StringUtil;
import com.sap.tc.webdynpro.progmodel.api.IWDComponent;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class AbstractConfigurationToolbarDataManipulator {
    private Class modelClass;
    private Class rootConfigClass;
    private IWDComponent wdComponentAPI;
    private String previewAppName;
    private IConfigurationManager configManager = new ConfigurationManager();
    private IConfigurationToolbarContext toolbarContext = new ConfigurationToolbarContext();
    private IConfigurationToolbarContext defToolbarContext;

    public AbstractConfigurationToolbarDataManipulator(IWDComponent component, Class model, Class rootConfigModel, String previewAppName, String previewAppConfigParamName) {
        this.wdComponentAPI = component;
        this.modelClass = model;
        this.rootConfigClass = rootConfigModel;
        this.previewAppName = previewAppName;
        this.defToolbarContext = new DefaultToolbarContext(this.wdComponentAPI, null, null, previewAppName, previewAppConfigParamName, false, false);
    }

    public IConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    public IConfigurationToolbarContext getConfigurationToolbarContext() {
        return this.toolbarContext;
    }

    protected abstract void saveData(String var1, String var2, Class var3, Class var4);

    protected abstract boolean loadData(String var1, String var2, Class var3, Class var4);

    protected abstract void setEditorVisible(boolean var1);

    protected abstract boolean isCalledStandalone();

    protected String getFileName(String configName) {
        return configName;
    }

    protected void preview(String configName) {
        this.defToolbarContext.preview(configName);
    }

    protected boolean isPreviewAvailable() {
        return !StringUtil.isEmpty((String)this.previewAppName);
    }

    protected boolean isHeaderVisible() {
        return false;
    }

    protected boolean showMessageArea() {
        return false;
    }

    protected List toolbarButtons() {
        return Collections.EMPTY_LIST;
    }

    protected void fireToolbarButtonPressed(String id) {
    }

    private class ConfigurationToolbarContext
    implements IConfigurationToolbarContext {
        private ConfigurationToolbarContext() {
        }

        public void create() {
            AbstractConfigurationToolbarDataManipulator.this.setEditorVisible(true);
            AbstractConfigurationToolbarDataManipulator.this.loadData("", "", AbstractConfigurationToolbarDataManipulator.this.modelClass, AbstractConfigurationToolbarDataManipulator.this.rootConfigClass);
        }

        public void reset() {
            AbstractConfigurationToolbarDataManipulator.this.setEditorVisible(false);
        }

        public void preview(String configName) {
            AbstractConfigurationToolbarDataManipulator.this.preview(configName);
        }

        public boolean isPreviewAvailable() {
            return AbstractConfigurationToolbarDataManipulator.this.isPreviewAvailable();
        }

        public boolean isHeaderVisible() {
            return AbstractConfigurationToolbarDataManipulator.this.isHeaderVisible();
        }

        public boolean showMessageArea() {
            return AbstractConfigurationToolbarDataManipulator.this.showMessageArea();
        }

        public List toolbarButtons() {
            return AbstractConfigurationToolbarDataManipulator.this.toolbarButtons();
        }

        public void fireToolbarButtonPressed(String id) {
            AbstractConfigurationToolbarDataManipulator.this.fireToolbarButtonPressed(id);
        }
    }

    private class ConfigurationManager
    implements IConfigurationManager {
        private ConfigurationManager() {
        }

        public void save(String configName) {
            AbstractConfigurationToolbarDataManipulator.this.saveData(configName, AbstractConfigurationToolbarDataManipulator.this.getFileName(configName), AbstractConfigurationToolbarDataManipulator.this.modelClass, AbstractConfigurationToolbarDataManipulator.this.rootConfigClass);
        }

        public boolean load(String configName) {
            if (AbstractConfigurationToolbarDataManipulator.this.isCalledStandalone()) {
                AbstractConfigurationToolbarDataManipulator.this.setEditorVisible(!StringUtil.isEmpty((String)configName));
            }
            boolean dataLoaded = AbstractConfigurationToolbarDataManipulator.this.loadData(configName, AbstractConfigurationToolbarDataManipulator.this.getFileName(configName), AbstractConfigurationToolbarDataManipulator.this.modelClass, AbstractConfigurationToolbarDataManipulator.this.rootConfigClass);
            if (AbstractConfigurationToolbarDataManipulator.this.isCalledStandalone()) {
                AbstractConfigurationToolbarDataManipulator.this.setEditorVisible(!StringUtil.isEmpty((String)configName) && dataLoaded);
            } else {
                AbstractConfigurationToolbarDataManipulator.this.setEditorVisible(true);
            }
            return StringUtil.isEmpty((String)configName) || dataLoaded;
        }

        public boolean delete(String configName) {
            ReposUtils.removeConfiguration((String)AbstractConfigurationToolbarDataManipulator.this.getFileName(configName), (String)AbstractConfigurationToolbarDataManipulator.this.rootConfigClass.getName(), (Class)AbstractConfigurationToolbarDataManipulator.this.modelClass, (WDDeployableObjectPart)AbstractConfigurationToolbarDataManipulator.this.wdComponentAPI.getDeployableObjectPart());
            return true;
        }

        public Set list() {
            return ICBConfigurationSearcher.ADVANCED_MODEL_CONFIGURATION_SEARCHER.listConfigurationNames(AbstractConfigurationToolbarDataManipulator.this.wdComponentAPI.getDeployableObjectPart());
        }
    }
}

