/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.ptn.common.components.componentbrowser.api;

import com.sap.caf.ui.ptn.common.components.componentbrowser.api.ICBConfigurationSearcher;
import com.sap.caf.ui.utils.repository.IConfigBrowser;
import com.sap.caf.ui.utils.repository.ReposUtils;
import com.sap.caf.ui.utils.repository.RepositoryToolkit;
import com.sap.tc.webdynpro.repository.RepositoryObjectInfo;
import com.sap.tc.webdynpro.repository.api.IWDRepository;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModel;
import com.sap.tc.webdynpro.repository.api.IWDRepositoryModelClassInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPartType;
import com.sap.tc.webdynpro.services.sal.deployment.core.DeployableObjectInternal;
import com.sap.tc.webdynpro.services.sal.deployment.core.IDeployableObject;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class ModelConfigSearcher
implements ICBConfigurationSearcher {
    private static final Class[] LOAD_MODEL_CLASS_ARGS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ModelConfigSearcher.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set listConfigurationNames(WDDeployableObjectPart component) {
        IWDDeployableObject dc = component.getDeployableObject();
        WDDeployableObjectPart[] parts = dc.getParts(WDDeployableObjectPartType.MODEL);
        TreeSet configNames = new TreeSet();
        IWDRepository repository = null;
        try {
            repository = ReposUtils.getRepository((IWDDeployableObject)dc);
            for (int i = 0; i < parts.length; ++i) {
                Class modelJavaClass = this.getModelClass(dc, parts[i]);
                IWDRepositoryModel model = repository.getRepositoryModel(modelJavaClass);
                Iterator modelClassInfoIt = model.associatedModelInfo().iterateModelClassInfos();
                while (modelClassInfoIt.hasNext()) {
                    Object next = modelClassInfoIt.next();
                    if (!(next instanceof RepositoryObjectInfo) || !((RepositoryObjectInfo)next).isMRO()) continue;
                    IWDRepositoryModelClassInfo modelClassInfo = (IWDRepositoryModelClassInfo)next;
                    IDeployableObject[] deployableObjects = DeployableObjectInternal.getDeployableObjectsInternal();
                    for (int j = 0; j < deployableObjects.length; ++j) {
                        IConfigBrowser configBrowser = RepositoryToolkit.createConfigBrowser((IWDDeployableObject)deployableObjects[j], (WDDeployableObjectPart)component);
                        try {
                            configNames.addAll(configBrowser.listAvailableConfigs(modelJavaClass, modelClassInfo.getName()));
                            continue;
                        }
                        finally {
                            configBrowser.close();
                        }
                    }
                }
            }
        }
        finally {
            if (repository != null) {
                repository.close();
            }
        }
        return configNames;
    }

    private Class getModelClass(IWDDeployableObject dc, WDDeployableObjectPart model) {
        try {
            Method classLoader = dc.getClass().getMethod("loadClass", LOAD_MODEL_CLASS_ARGS);
            return (Class)classLoader.invoke((Object)dc, model.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

