/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.ui.ptn.common.components.componentbrowser.api;

import com.sap.caf.ui.ptn.common.components.componentbrowser.api.IComponentFilter;
import com.sap.caf.ui.utils.repository.IWDRepositoryBrowser;
import com.sap.caf.ui.utils.repository.RepositoryToolkit;
import com.sap.tc.webdynpro.progmodel.repository.IWDComponentInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDComponentInterfaceDefinitionInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObject;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDSharingAccessException;
import java.util.HashSet;
import java.util.Set;

public class ComponentFilterByInterface
implements IComponentFilter {
    private IWDDeployableObject _deployableObject;
    private IWDComponentInterfaceDefinitionInfo _iface;
    private Set _referencedDC;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentFilterByInterface(String dcName, String interfaceClass) {
        this._deployableObject = WDDeployableObject.getDeployableObject((String)dcName);
        IWDRepositoryBrowser browser = RepositoryToolkit.createWebdynproRepositoryBrowser((IWDDeployableObject)this._deployableObject);
        try {
            this._iface = browser.getComponentInterfaceDefenitionInfo(interfaceClass);
        }
        finally {
            browser.close();
        }
        this._referencedDC = new HashSet();
        this._referencedDC.add(this._deployableObject);
        try {
            IWDDeployableObject[] deployments = this._deployableObject.isReferencedByObjects();
            for (int i = 0; i < deployments.length; ++i) {
                this._referencedDC.add(deployments[i]);
            }
        }
        catch (WDSharingAccessException exOnGetReferers) {
            throw new RuntimeException(exOnGetReferers);
        }
    }

    public boolean accept(IWDComponentInfo componentInfo) {
        if (this._iface == null) {
            return true;
        }
        if (!componentInfo.hasComponentInterface()) {
            return false;
        }
        HashSet componentIntfs = new HashSet(componentInfo.getComponentInterface().getImplementedInterfaces());
        return componentIntfs.contains(this._iface);
    }

    public boolean acceptDC(IWDDeployableObject obj) {
        return this._referencedDC.contains(obj);
    }
}

