/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.dom.property.IDesignPropertySetDescriptor;
import com.tssap.selena.dom.property.IDesignPropertySetValidator;
import com.tssap.selena.dom.property.NotValidatableDescriptor;
import com.tssap.selena.internal.dom.DOMPlugin;
import com.tssap.selena.internal.dom.providers.CompositePropertySetDescriptor;
import com.tssap.selena.internal.dom.providers.NamePropertyDescriptor;
import com.tssap.selena.internal.dom.providers.PropertySetDescriptorImpl;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class PropertySetRegistry {
    public static final String EXT_POINT_DESIGN_PROPERTY_DESCRIPTORS = "designPropertyDescriptors";
    public static final String ATTR_PROPERTY_NAME = "propertyName";
    public static final String ATTR_CLASS = "class";
    private static PropertySetRegistry myself;
    private HashMap myPropertySetDescriptorImplCache = new HashMap();

    private PropertySetRegistry() {
        this.initPredefinedDescriptors();
        this.initUserDescriptors();
    }

    public static PropertySetRegistry getInstance() {
        if (myself == null) {
            myself = new PropertySetRegistry();
        }
        return myself;
    }

    public IDesignPropertySetValidator getValidator(String propertyName) {
        CompositePropertySetDescriptor descriptor = this.getCompositeDescriptor(propertyName);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getValidator();
    }

    private CompositePropertySetDescriptor getCompositeDescriptor(String propertyName) {
        return (CompositePropertySetDescriptor)this.myPropertySetDescriptorImplCache.get(propertyName);
    }

    public boolean isWritable(String propertyName, String metaclass) {
        CompositePropertySetDescriptor descriptor = this.getCompositeDescriptor(propertyName);
        if (descriptor == null) {
            return false;
        }
        return descriptor.isApplicable(metaclass);
    }

    public boolean isMutableProperty(String propertyName, String metaclass) {
        CompositePropertySetDescriptor descriptor = this.getCompositeDescriptor(propertyName);
        if (descriptor == null) {
            return false;
        }
        return descriptor.isMutable() && descriptor.isApplicable(metaclass);
    }

    public boolean isMultivaluedProperty(String propertyName, String metaclass) {
        CompositePropertySetDescriptor descriptor = this.getCompositeDescriptor(propertyName);
        if (descriptor == null) {
            return false;
        }
        return descriptor.isMultivalued() && descriptor.isApplicable(metaclass);
    }

    private void addDescriptor(IDesignPropertySetDescriptor newDescriptor) {
        String propertyName = newDescriptor.getPropertyName();
        if (propertyName == null) {
            System.err.println("attempt to add descriptor for propertyName == null ");
            return;
        }
        CompositePropertySetDescriptor cached = this.getCompositeDescriptor(propertyName);
        if (cached == null) {
            cached = new CompositePropertySetDescriptor(propertyName);
            this.myPropertySetDescriptorImplCache.put(propertyName, cached);
        }
        cached.addDescriptor(newDescriptor);
    }

    private void initPredefinedDescriptors() {
        this.addDescriptor(new PropertySetDescriptorImpl("$metaclass", true, false));
        this.addDescriptor(new NamePropertyDescriptor());
        this.addDescriptor(new PropertySetDescriptorImpl("@stereotype", true, true));
        this.addDescriptor(new PropertySetDescriptorImpl("$description", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$explanation", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$instantiates", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$persistence", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$concurrent", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$active", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$multiple_instance", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$state", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$explanation", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$note_text", true, false, "Note"));
        this.addDescriptor(new PropertySetDescriptorImpl("text_only", true, false, "Note"));
        this.addDescriptor(new PropertySetDescriptorImpl("$rank", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$abstract", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$normal_flow", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$alternate_flow", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$deep", true, false, "History"));
        this.addDescriptor(new PropertySetDescriptorImpl("$synchronization_condition", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$target_class", true, false, "Activity Diagram"));
        this.addDescriptor(new PropertySetDescriptorImpl("@preconditions", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@postconditions", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$event_arguments", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$condition", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$guard_condition", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$action_expression", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$send_clause", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$type", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$orientation", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$old_orientation", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@label", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@labelDirection", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@link", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@associationAsClass", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@clientRole", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@clientCardinality", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@clientQualifier", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@supplierRole", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@supplierCardinality", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@supplierQualifier", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@directed", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$constraint", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$event_name", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$send_time", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("$receive_time", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@type", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@number", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@document", true, true));
        this.addDescriptor(new PropertySetDescriptorImpl("@description", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@author", true, true));
        this.addDescriptor(new PropertySetDescriptorImpl("@priority", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@difficulty", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@testcase", true, false));
        this.addDescriptor(new PropertySetDescriptorImpl("@url", true, true));
        this.addDescriptor(new PropertySetDescriptorImpl("$packageDependency:targetUin", true, true));
    }

    private void initUserDescriptors() {
        IExtensionPoint point = DOMPlugin.getDefault().getDescriptor().getExtensionPoint(EXT_POINT_DESIGN_PROPERTY_DESCRIPTORS);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                block9: {
                    IConfigurationElement element = elements[j];
                    String propertyName = element.getAttribute(ATTR_PROPERTY_NAME);
                    if (propertyName != null) {
                        IDesignPropertySetDescriptor descriptor = null;
                        try {
                            if (element.getAttribute(ATTR_CLASS) == null) {
                                NotValidatableDescriptor defaultDescriptor = new NotValidatableDescriptor();
                                defaultDescriptor.setInitializationData(element, ATTR_CLASS, null);
                                descriptor = defaultDescriptor;
                            } else {
                                descriptor = (IDesignPropertySetDescriptor)element.createExecutableExtension(ATTR_CLASS);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Can not instantiate Property descriptor for propertyName: " + propertyName + " :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            break block9;
                        }
                        catch (NoClassDefFoundError e) {
                            System.err.println("Can not instantiate Property descriptor for propertyName: " + propertyName + " :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            break block9;
                        }
                        if (descriptor != null) {
                            this.addDescriptor(descriptor);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

