/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.dom.property.IDesignPropertySetDescriptor;
import com.tssap.selena.dom.property.IDesignPropertySetValidator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class PropertySetDescriptorImpl
implements IDesignPropertySetDescriptor {
    private boolean myMutable;
    private boolean myMultivalued;
    private String myName;
    private Collection myApplicableMetaclasses = new HashSet();
    private boolean myApplicableToAll;

    public PropertySetDescriptorImpl(String name, boolean mutable, boolean multivalued, String metaclass) {
        this.myName = name;
        this.myMutable = mutable;
        this.myMultivalued = multivalued;
        this.myApplicableMetaclasses.add(metaclass);
    }

    public PropertySetDescriptorImpl(String name, boolean mutable, boolean multivalued, String[] metaclasses) {
        this.myName = name;
        this.myMutable = mutable;
        this.myMultivalued = multivalued;
        this.myApplicableMetaclasses.addAll(Arrays.asList(metaclasses));
    }

    public PropertySetDescriptorImpl(String name, boolean mutable, boolean multivalued) {
        this.myName = name;
        this.myMutable = mutable;
        this.myMultivalued = multivalued;
        this.myApplicableToAll = true;
    }

    public boolean isMutable() {
        return this.myMutable;
    }

    public boolean isMultivalued() {
        return this.myMultivalued;
    }

    public boolean isApplicable(String metaclass) {
        return this.myApplicableToAll || this.myApplicableMetaclasses.contains(metaclass);
    }

    public String getPropertyName() {
        return this.myName;
    }

    public IDesignPropertySetValidator getValidator() {
        return null;
    }
}

