/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.internal.dom.providers.BackwardCompatibilityRootRepairer;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProjectDescriptionParser {
    private static final String DESIGN_ROOT_TAG = "designRoot";
    private static final String ATTRIBUTE_NAME = "path";
    private IProject myProject;
    private Document myDocument;

    public ProjectDescriptionParser(IProject project) {
        this.myProject = project;
        this.loadDocument();
    }

    public String getDesignRoot() {
        String result = this.primGetDesignRoot();
        if (result != null) {
            return result;
        }
        return BackwardCompatibilityRootRepairer.checkOldDefaultRoot(this.myProject, this);
    }

    private String primGetDesignRoot() {
        if (!this.myProject.isAccessible() || this.myDocument == null) {
            return null;
        }
        Element rootDocument = this.myDocument.getDocumentElement();
        Assert.isLegal((rootDocument != null && "projectDescription".equals(rootDocument.getNodeName()) ? 1 : 0) != 0, (String)("Unexpected projectDescription format : root: " + rootDocument));
        NodeList designRootElements = rootDocument.getElementsByTagName(DESIGN_ROOT_TAG);
        if (designRootElements == null || designRootElements.getLength() == 0) {
            return null;
        }
        return ((Element)designRootElements.item(0)).getAttribute(ATTRIBUTE_NAME);
    }

    public boolean setDesignRoot(String newDesignRoot) {
        if (!this.myProject.isAccessible() || this.myDocument == null) {
            return false;
        }
        Element rootDocument = this.myDocument.getDocumentElement();
        Assert.isLegal((rootDocument != null && "projectDescription".equals(rootDocument.getNodeName()) ? 1 : 0) != 0, (String)("Unexpected projectDescription format : root: " + rootDocument));
        NodeList designRootElements = rootDocument.getElementsByTagName(DESIGN_ROOT_TAG);
        Element newDesignRootEntry = null;
        newDesignRootEntry = designRootElements == null || designRootElements.getLength() == 0 ? (Element)rootDocument.appendChild(this.myDocument.createElement(DESIGN_ROOT_TAG)) : (Element)designRootElements.item(0);
        if (newDesignRootEntry != null) {
            newDesignRootEntry.setAttribute(ATTRIBUTE_NAME, newDesignRoot);
            ProjectDescriptionParser.saveContents(this.myDocument, this.getProjectDescriptionFile());
            return true;
        }
        return false;
    }

    private void loadDocument() {
        if (this.myDocument == null) {
            IFile descriptionFile = this.getProjectDescriptionFile();
            if (descriptionFile == null || !descriptionFile.exists()) {
                return;
            }
            this.myDocument = ProjectDescriptionParser.parse(descriptionFile);
        }
    }

    private IFile getProjectDescriptionFile() {
        return this.myProject.getFile(".project");
    }

    private static void saveContents(final Document newDocument, final IFile descriptionFile) {
        if (descriptionFile == null || !descriptionFile.exists()) {
            return;
        }
        UndoTransparableCommand saveCommand = new UndoTransparableCommand(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                IStatus canEditStatus = descriptionFile.getWorkspace().validateEdit(new IFile[]{descriptionFile}, null);
                if (canEditStatus.getSeverity() >= 4) {
                    return;
                }
                ByteArrayOutputStream newOutput = new ByteArrayOutputStream(5000);
                ByteArrayInputStream newInput = null;
                OutputFormat format = new OutputFormat();
                format.setPreserveSpace(true);
                try {
                    try {
                        Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer((OutputStream)newOutput, format);
                        serializer.asDOMSerializer().serialize(newDocument);
                        newInput = new ByteArrayInputStream(newOutput.toByteArray());
                        descriptionFile.setContents((InputStream)newInput, true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception cantSave) {
                        cantSave.printStackTrace();
                        Object var7_8 = null;
                        ProjectDescriptionParser.finallyCloseStream(newOutput);
                        ProjectDescriptionParser.finallyCloseStream(newInput);
                        return;
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    ProjectDescriptionParser.finallyCloseStream(newOutput);
                    ProjectDescriptionParser.finallyCloseStream(newInput);
                    throw throwable;
                }
                ProjectDescriptionParser.finallyCloseStream(newOutput);
                ProjectDescriptionParser.finallyCloseStream(newInput);
            }
        };
        ModelAccess.runCommandLater((Runnable)saveCommand);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document parse(IFile descriptionFile) {
        Document document;
        if (descriptionFile == null) return null;
        if (!descriptionFile.exists()) {
            return null;
        }
        InputStream contents = null;
        try {
            try {
                contents = descriptionFile.getContents();
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = documentBuilder.parse(contents);
                Object var5_5 = null;
            }
            catch (Exception contentsNotAvailable) {
                System.err.println("can access contents for project description file: " + descriptionFile.getFullPath() + "\n" + contentsNotAvailable);
                Object var5_6 = null;
                ProjectDescriptionParser.finallyCloseStream(contents);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            ProjectDescriptionParser.finallyCloseStream(contents);
            throw throwable;
        }
        ProjectDescriptionParser.finallyCloseStream(contents);
        return document;
    }

    private static void finallyCloseStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException cantClose) {
            cantClose.printStackTrace();
        }
    }

    private static void finallyCloseStream(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException cantClose) {
            cantClose.printStackTrace();
        }
    }
}

