/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.enum.ReferenceCollectionEnumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;

public class NameUtil {
    private static final String DESIGN_DOMAIN = "design";
    private static final String NODE_SUBDOMAIN = "node";
    private static final String LINK_SUBDOMAIN = "link";
    private static final String VIEW_SUBDOMAIN = "view";
    private static final HashMap CLASSES2SUB_DOMAINS = new HashMap();
    private static Random myRandomUinCreator;
    static /* synthetic */ Class class$com$tssap$selena$dom$DesignNode;
    static /* synthetic */ Class class$com$tssap$selena$dom$DesignLink;
    static /* synthetic */ Class class$com$tssap$selena$dom$DesignView;

    public static DesignElement getElement(NodeSetCache cache, UniqueName uniqueName) {
        if (!NameUtil.isDesignUin(uniqueName)) {
            return null;
        }
        int parameterIndex = uniqueName.getParametersCount() - 1;
        String topLevelParentId = uniqueName.getParameter(parameterIndex);
        DesignElement result = cache.findElement(topLevelParentId);
        while (result != null && parameterIndex > 0) {
            if (!(result instanceof DesignNode)) {
                return null;
            }
            String curChildId = uniqueName.getParameter(--parameterIndex);
            result = ((DesignNode)result).getChild(curChildId);
        }
        if (result == null) {
            return null;
        }
        if (NameUtil.checkSubDomain(uniqueName, result)) {
            return result;
        }
        return null;
    }

    public static UniqueName getUniqueName(DesignElement element) {
        String subDomain = NameUtil.getSubDomain(element);
        String[] parentsChain = NameUtil.createParentsChain(element);
        return ModelAccess.createUniqueName((String)DESIGN_DOMAIN, (String)subDomain, null, null, (String[])parentsChain);
    }

    private static boolean checkSubDomain(UniqueName uin, DesignElement element) {
        String subDomain = uin.getSubDomain();
        return "" != subDomain && subDomain.equals(NameUtil.getSubDomain(element));
    }

    private static String[] createParentsChain(DesignElement element) {
        LinkedList<String> chain = new LinkedList<String>();
        DesignElement ancestor = element;
        while (ancestor != null) {
            String curId = ancestor.getId();
            chain.add(curId);
            ancestor = (DesignElement)ancestor.getParent();
        }
        return chain.toArray(new String[chain.size()]);
    }

    private static String getSubDomain(DesignElement element) {
        return (String)CLASSES2SUB_DOMAINS.get(element.getClass());
    }

    public static String newDesignId(String metaclass) {
        return Integer.toString(metaclass.hashCode(), 36) + Long.toString(System.currentTimeMillis(), 36) + Integer.toString(myRandomUinCreator.nextInt(), 36);
    }

    public static boolean isDesignUin(UniqueName uniqueName) {
        return DESIGN_DOMAIN.equals(uniqueName.getDomain()) && "" == uniqueName.getLocation() && "" == uniqueName.getName() && uniqueName.getParametersCount() > 0 && CLASSES2SUB_DOMAINS.containsValue(uniqueName.getSubDomain());
    }

    public static boolean isDesignViewUin(UniqueName uniqueName) {
        return NameUtil.isDesignUin(uniqueName) && VIEW_SUBDOMAIN.equals(uniqueName.getSubDomain());
    }

    public static boolean isDesignNodeUin(UniqueName uniqueName) {
        return NameUtil.isDesignUin(uniqueName) && NODE_SUBDOMAIN.equals(uniqueName.getSubDomain());
    }

    public static boolean isDesignLinkUin(UniqueName uniqueName) {
        return NameUtil.isDesignUin(uniqueName) && LINK_SUBDOMAIN.equals(uniqueName.getSubDomain());
    }

    public static UniqueName getFolderUin(IFolder folder, Model model) {
        return DesignRootAccess.getInstance(folder.getProject()).findResourceElementUin((IContainer)folder);
    }

    public static String getNewName(Entity parent, String shapeType, Entity template) {
        if (template != null && template.hasProperty("$name")) {
            return template.getPropertyValue("$name");
        }
        if (template != null && template.getPropertyValue("$nametemplate") != null) {
            shapeType = template.getPropertyValue("$nametemplate");
        }
        return NameUtil.getNewName(parent, shapeType);
    }

    public static Entity addNewNameToTemplate(Entity parent, String shapeType, Entity template) {
        if (template == null || template.hasProperty("$name")) {
            return template;
        }
        String newName = NameUtil.getNewName(parent, shapeType, template);
        template.setPropertyValue("$name", newName);
        return template;
    }

    private static String getNewName(Entity parent, String shapeType) {
        HashSet<String> namesInUse = new HashSet<String>();
        EntityEnumeration children = parent.childEntities();
        while (children.hasMoreElements()) {
            String nextName = children.next().getPropertyValue("$name");
            if (nextName == null || !nextName.startsWith(shapeType)) continue;
            namesInUse.add(nextName);
        }
        ReferenceCollectionEnumeration childRCs = parent.childReferenceCollections();
        while (childRCs.hasMoreElements()) {
            String nextName = childRCs.next().getPropertyValue("$name");
            if (nextName == null || !nextName.startsWith(shapeType)) continue;
            namesInUse.add(nextName);
        }
        int nameSuffix = 1;
        String name;
        while (namesInUse.contains(name = shapeType + nameSuffix)) {
            ++nameSuffix;
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CLASSES2SUB_DOMAINS.put(class$com$tssap$selena$dom$DesignNode == null ? (class$com$tssap$selena$dom$DesignNode = NameUtil.class$("com.tssap.selena.dom.DesignNode")) : class$com$tssap$selena$dom$DesignNode, NODE_SUBDOMAIN);
        CLASSES2SUB_DOMAINS.put(class$com$tssap$selena$dom$DesignLink == null ? (class$com$tssap$selena$dom$DesignLink = NameUtil.class$("com.tssap.selena.dom.DesignLink")) : class$com$tssap$selena$dom$DesignLink, LINK_SUBDOMAIN);
        CLASSES2SUB_DOMAINS.put(class$com$tssap$selena$dom$DesignView == null ? (class$com$tssap$selena$dom$DesignView = NameUtil.class$("com.tssap.selena.dom.DesignView")) : class$com$tssap$selena$dom$DesignView, VIEW_SUBDOMAIN);
        myRandomUinCreator = new Random();
    }
}

