/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.internal.dom.providers.AbstractPropertyProvider;
import com.tssap.selena.internal.dom.providers.DesignPropertyAdapter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class GenericGetPropertyProvider
extends AbstractPropertyProvider
implements PropertyGetProvider {
    public String getPropertyValue(Element element, String propertyName) {
        DesignProperty[] properties;
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null && (properties = owner.getProperties(propertyName)) != null && properties.length > 0) {
            return properties[0].getValue();
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        DesignProperty[] properties;
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null && (properties = owner.getProperties(propertyName)) != null && properties.length > 0) {
            return new DesignPropertyAdapter(properties[0], element);
        }
        return null;
    }

    public boolean hasProperty(Element element, String propertyName) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null) {
            DesignProperty[] properties = owner.getProperties(propertyName);
            return properties != null && properties.length > 0;
        }
        return false;
    }

    public PropertyEnumeration properties(Element element) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null) {
            return this.properties(owner.getProperties(), element);
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null) {
            return this.properties(owner.getProperties(propertyName), element);
        }
        return EmptyEnumeration.getPropertyEnumeration();
    }

    private PropertyEnumeration properties(DesignProperty[] properties, Element element) {
        ArrayList<DesignPropertyAdapter> result = new ArrayList<DesignPropertyAdapter>();
        int i = 0;
        while (i < properties.length) {
            result.add(new DesignPropertyAdapter(properties[i], element));
            ++i;
        }
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(result));
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        if (propertyValue == null) {
            return false;
        }
        DesignNotion owner = this.getPropertyOwner(element);
        if (owner != null) {
            DesignProperty[] properties = owner.getProperties(propertyName);
            int i = 0;
            while (i < properties.length) {
                if (propertyValue.equals(properties[i].getValue())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

