/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DesignRootPropertyProvider
extends AbstractDesignProvider
implements PropertyGetProvider,
PropertySetProvider {
    public static final String DESIGN_ROOT_PROPERTY = "$design_root";

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (element instanceof Model) {
            IProject project = ModelUinSupport.getProject((UniqueName)element.getUniqueName());
            return project != null && project.isAccessible();
        }
        return false;
    }

    public String getPropertyValue(Element element, String propertyName) {
        return DesignRootAccess.getInstance(this.getProject()).getRootPath().toString();
    }

    public Property getProperty(Element element, String propertyName) {
        String result = this.getPropertyValue(element, propertyName);
        return result == null ? null : new PropertyAdapter(propertyName, result, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, DESIGN_ROOT_PROPERTY);
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property result = this.getProperty(element, propertyName);
        return result == null ? EmptyEnumeration.getPropertyEnumeration() : SingleEnumeration.createPropertyEnumeration((Property)result);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return true;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        DesignRootAccess.getInstance(this.getProject()).setRootPath((IPath)new Path(propertyValue));
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }
}

