/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.internal.dom.copypaste.DesignClipboardManager;
import com.tssap.selena.internal.dom.copypaste.IDesignClipboardCopy;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.PasteProvider;

public class DesignPasteProvider
extends AbstractDesignProvider
implements PasteProvider,
EntityExistenceProvider,
ModelAware {
    private DesignClipboardManager myClipboardManager;

    public void registered(Model model) {
        super.registered(model);
        this.myClipboardManager = DesignClipboardManager.getInstance(model);
    }

    public void unregistered(Model model) {
        if (this.myClipboardManager != null) {
            this.myClipboardManager.clearAll();
            this.myClipboardManager = null;
        }
        super.unregistered(model);
    }

    public boolean isPasteProviderApplicable(Entity container) {
        return true;
    }

    public boolean canPaste(Entity container, Element element, Element anchor, boolean before) {
        IDesignClipboardCopy clipboardCopy = this.myClipboardManager.getCopy(element.getUniqueName());
        return clipboardCopy != null && clipboardCopy.canPaste(container);
    }

    public UniqueName paste(Entity container, Element element, Element createdElement, Element anchor, boolean before) {
        IDesignClipboardCopy clipboardCopy = this.myClipboardManager.getCopy(element.getUniqueName());
        Entity result = clipboardCopy.paste(container);
        return result == null ? null : result.getUniqueName();
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return this.exists(element.getUniqueName());
    }

    public boolean exists(UniqueName uniqueName) {
        return this.myClipboardManager.getCopy(uniqueName) != null;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        this.myClipboardManager.removeCopy(element.getUniqueName());
    }

    public boolean isDeleted(Element element) {
        return false;
    }
}

