/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.dom.property.IDesignPropertySetDescriptor;
import com.tssap.selena.dom.property.IDesignPropertySetValidator;
import com.tssap.selena.model.elements.Element;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class CompositePropertySetDescriptor
implements IDesignPropertySetDescriptor {
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    };
    private String myPropertyName;
    private HashSet myDescriptors;

    public CompositePropertySetDescriptor(String propertyName) {
        this.myPropertyName = propertyName;
    }

    public CompositePropertySetDescriptor(IDesignPropertySetDescriptor first) {
        this(first.getPropertyName());
        this.addDescriptor(first);
    }

    public void addDescriptor(IDesignPropertySetDescriptor descriptor) {
        if (!this.myPropertyName.equals(descriptor.getPropertyName())) {
            throw new IllegalStateException("CompositePropertySetDescriptor:: attempt to add descriptor for another property Name: \n\t myName: " + this.myPropertyName + "\n\t addedName: " + descriptor.getPropertyName());
        }
        if (this.myDescriptors == null) {
            this.myDescriptors = new HashSet();
        }
        this.myDescriptors.add(descriptor);
    }

    public boolean isMutable() {
        Iterator descriptors = this.getDescriptors();
        while (descriptors.hasNext()) {
            IDesignPropertySetDescriptor curDescriptor = (IDesignPropertySetDescriptor)descriptors.next();
            if (curDescriptor.isMutable()) continue;
            return false;
        }
        return true;
    }

    public boolean isMultivalued() {
        Iterator descriptors = this.getDescriptors();
        while (descriptors.hasNext()) {
            IDesignPropertySetDescriptor curDescriptor = (IDesignPropertySetDescriptor)descriptors.next();
            if (!curDescriptor.isMultivalued()) continue;
            return true;
        }
        return false;
    }

    public boolean isApplicable(String metaclass) {
        Iterator descriptors = this.getDescriptors();
        while (descriptors.hasNext()) {
            IDesignPropertySetDescriptor curDescriptor = (IDesignPropertySetDescriptor)descriptors.next();
            if (!curDescriptor.isApplicable(metaclass)) continue;
            return true;
        }
        return false;
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    public IDesignPropertySetValidator getValidator() {
        final LinkedList<IDesignPropertySetValidator> validators = new LinkedList<IDesignPropertySetValidator>();
        Iterator descriptors = this.getDescriptors();
        while (descriptors.hasNext()) {
            IDesignPropertySetDescriptor curDescriptor = (IDesignPropertySetDescriptor)descriptors.next();
            IDesignPropertySetValidator curValidator = curDescriptor.getValidator();
            if (curValidator == null) continue;
            validators.add(curValidator);
        }
        if (validators.isEmpty()) {
            return null;
        }
        return new IDesignPropertySetValidator(){

            public boolean isValidValue(Element element, String propertyName, String propertyValue) {
                Iterator it = validators.iterator();
                while (it.hasNext()) {
                    IDesignPropertySetValidator curValidator = (IDesignPropertySetValidator)it.next();
                    if (curValidator.isValidValue(element, propertyName, propertyValue)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private Iterator getDescriptors() {
        if (this.myDescriptors == null) {
            return EMPTY_ITERATOR;
        }
        return this.myDescriptors.iterator();
    }
}

