/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;

public abstract class AbstractStructureProvider
extends AbstractDesignProvider
implements ChildrenProvider {
    public boolean isChildrenProviderApplicable(Entity parent) {
        return NameUtil.isDesignNodeUin(parent.getUniqueName()) || parent instanceof Model || parent.hasPropertyValue("$metaclass", "Package");
    }

    public UniqueNameEnumeration children(Entity parent) {
        if (NameUtil.isDesignNodeUin(parent.getUniqueName())) {
            DesignNode designParent = (DesignNode)this.getDesignElement(parent.getUniqueName());
            if (designParent == null) {
                System.err.println("ATTENTION! -- can not find elelent: " + parent.getUniqueName());
                return EmptyEnumeration.getUniqueNameEnumeration();
            }
            return this.children(designParent);
        }
        return this.children(this.getFolder(parent.getPropertyValue("$diagram_folder")));
    }

    protected final UniqueNameEnumeration children(IContainer folder) {
        if (folder == null || !folder.exists()) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        ArrayList<UniqueName> children = new ArrayList<UniqueName>();
        DesignNodeSet[] nodeSets = this.getCache().nodeSets(folder);
        int i = 0;
        while (i < nodeSets.length) {
            DesignNodeSet curNodeSet = nodeSets[i];
            if (curNodeSet.getParent() == null) {
                Iterator members = curNodeSet.iterator();
                while (members.hasNext()) {
                    DesignElement curChild = (DesignElement)members.next();
                    if (!this.customIsApplicable(curChild)) continue;
                    children.add(NameUtil.getUniqueName(curChild));
                }
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(children));
    }

    protected UniqueNameEnumeration children(DesignNode node) {
        ArrayList<UniqueName> children = new ArrayList<UniqueName>();
        DesignElement[] childElements = this.getChildrenOfOurType(node);
        int i = 0;
        while (i < childElements.length) {
            children.add(NameUtil.getUniqueName(childElements[i]));
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(children));
    }

    protected abstract boolean customIsApplicable(DesignElement var1);

    protected abstract DesignElement[] getChildrenOfOurType(DesignNode var1);
}

