/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.extension.Provider;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class AbstractDesignProvider
implements Provider,
ModelAware {
    private UniqueName myModelUin;

    public void registered(Model model) {
        Assert.isLegal((model != null ? 1 : 0) != 0);
        this.myModelUin = model.getUniqueName();
    }

    public void unregistered(Model model) {
        Assert.isLegal((model != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)model.getUniqueName().equals(this.myModelUin));
        this.myModelUin = null;
    }

    public final UniqueName getModelUin() {
        return this.myModelUin;
    }

    protected final IProject getProject() {
        return ModelUinSupport.getProject((UniqueName)this.myModelUin);
    }

    protected NodeSetCache getCache() {
        return NodeSetCache.getCache(this.myModelUin);
    }

    protected DesignElement getDesignElement(UniqueName uniqueName) {
        if (!NameUtil.isDesignUin(uniqueName)) {
            return null;
        }
        return NameUtil.getElement(this.getCache(), uniqueName);
    }

    protected IContainer getFolder(String rootRelativePathAsString) {
        if (rootRelativePathAsString == null) {
            return DesignRootAccess.getInstance(this.getProject()).getDesignRoot();
        }
        Path rootRelativePath = new Path(rootRelativePathAsString);
        if (rootRelativePath.isEmpty()) {
            return DesignRootAccess.getInstance(this.getProject()).getDesignRoot();
        }
        IContainer result = DesignRootAccess.getInstance(this.getProject()).createUnderDesignRoot((IPath)rootRelativePath);
        return result;
    }

    protected boolean isReadOnly(DesignNotion designNotion) {
        return designNotion == null || designNotion.isReadOnly();
    }

    protected final boolean isReadOnly(Entity modelEntity) {
        if (modelEntity == null) {
            return true;
        }
        NodeSetCache cache = NodeSetCache.getCache(modelEntity.getModel().getUniqueName());
        return this.isReadOnly(NameUtil.getElement(cache, modelEntity.getUniqueName()));
    }
}

