/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.providers;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.ParentProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;

public abstract class AbstractDesignParentProvider
extends AbstractDesignProvider
implements ParentProvider {
    public UniqueName getParentUniqueName(Element child) {
        UniqueName uniqueName = child.getUniqueName();
        if (!NameUtil.isDesignUin(uniqueName)) {
            return null;
        }
        DesignElement designElement = this.getDesignElement(uniqueName);
        if (designElement == null) {
            return null;
        }
        if (!this.customIsApplicable(designElement)) {
            return null;
        }
        return this.customGetParentUin(designElement);
    }

    protected UniqueName commonGetParentUin(DesignElement designElement) {
        DesignNode parent = (DesignNode)designElement.getParent();
        if (parent != null) {
            return NameUtil.getUniqueName(parent);
        }
        parent = designElement.getNodeSet().getParent();
        if (parent != null) {
            return NameUtil.getUniqueName(parent);
        }
        IContainer fileParent = designElement.getFile().getParent();
        switch (fileParent.getType()) {
            case 4: {
                return this.getModelUin();
            }
            case 2: {
                return NameUtil.getFolderUin((IFolder)fileParent, ModelAccess.getModel((UniqueName)this.getModelUin()));
            }
        }
        return null;
    }

    protected abstract boolean customIsApplicable(DesignElement var1);

    protected abstract UniqueName customGetParentUin(DesignElement var1);
}

