/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.io;

import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.io.AbstractReaderState;
import com.tssap.selena.internal.dom.io.NonCrypticDesignFactory;
import com.tssap.selena.internal.dom.io.StatesManager;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.xml.sax.Attributes;

public class StartState
extends AbstractReaderState {
    private NodeSetCache myNodeSetCache;
    private Stack myFilesStack = new Stack();
    private Stack myNodeSetStack = new Stack();

    public StartState(StatesManager statesManager, NodeSetCache cache) {
        super(statesManager);
        this.myNodeSetCache = cache;
    }

    public void setCurrentCache(NodeSetCache cache) {
        this.myNodeSetCache = cache;
    }

    protected void clear() {
        this.myFilesStack.clear();
        this.myNodeSetStack.clear();
    }

    private IFile getFile() {
        return (IFile)this.myFilesStack.peek();
    }

    public void fileStarted(IFile file) {
        if (this.myFilesStack.contains(file)) {
            throw new IllegalStateException("Cycle in node-set hierarchy: " + this.myFilesStack);
        }
        this.myFilesStack.push(file);
    }

    public void fileEnded() {
        this.myFilesStack.pop();
    }

    public DesignNodeSet popNodeSet() {
        if (this.myNodeSetStack.isEmpty()) {
            return null;
        }
        return (DesignNodeSet)this.myNodeSetStack.pop();
    }

    public DesignNode getParentNode() {
        return this.hasParsedElement() ? null : (DesignNode)this.peekParsedElement();
    }

    public AbstractReaderState processStartElement(String uri, String localName, String qName, Attributes attributes) {
        AbstractReaderState result = null;
        if ("nodeSet".equals(qName) && NonCrypticDesignFactory.canCreateNodeSet(this.myNodeSetCache, this.getFile(), this.getParentNode(), attributes)) {
            DesignNodeSet newNodeSet = NonCrypticDesignFactory.createNodeSet(this.myNodeSetCache, this.getFile(), this.getParentNode(), attributes);
            this.pushParsedElement(newNodeSet);
            this.myNodeSetStack.push(newNodeSet);
            result = this.getStatesManager().READING_NODESET_STATE;
        } else {
            result = this.getStatesManager().SKIPPING_INNERS_STATE;
        }
        return result;
    }

    public void processEndElement(String uri, String localName, String qName) {
    }
}

