/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.io;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignParticipant;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignProxy;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IDesignVisitor;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.internal.dom.DOMPlugin;
import com.tssap.selena.internal.dom.io.XMLStructure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;

public class SerializeVisitor
implements IDesignVisitor,
XMLStructure {
    private static final String CAPTION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
    private StringBuffer myContents = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
    private int myTabLevel = 0;
    private DesignNodeSet myNodeSet;

    public SerializeVisitor(DesignNodeSet nodeSet) {
        this.myNodeSet = nodeSet;
    }

    public static String getStartSerializedParticipant(String proxyId, String participantRole) {
        StringBuffer result = new StringBuffer();
        result.append("<").append("participant").append(" ");
        result.append(SerializeVisitor.prepareProxyAttribute(proxyId)).append(" ");
        result.append("role").append("=");
        result.append(SerializeVisitor.addQuots(SerializeVisitor.normalize(participantRole)));
        result.append(">");
        return result.toString();
    }

    public InputStream serialize() throws CoreException {
        this.myContents = new StringBuffer(CAPTION);
        this.myTabLevel = 0;
        try {
            this.myNodeSet.accept(this);
            if (this.myTabLevel != 0) {
                throw new IllegalStateException("Element has not been properly serialized");
            }
            return new ByteArrayInputStream(this.myContents.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            DOMPlugin.getDefault().propagateException(e);
            return null;
        }
    }

    public boolean visitLink(DesignLink link) throws Exception {
        return this.visitElement(link, "link");
    }

    public boolean visitNode(DesignNode node) throws Exception {
        return this.visitElement(node, "node");
    }

    public boolean visitView(DesignView view) throws Exception {
        return this.visitElement(view, "view");
    }

    private boolean visitElement(DesignElement element, String tag) {
        this.printTabs();
        this.myContents.append("<").append(tag).append(" ");
        this.myContents.append(this.prepareUinAttribute(element)).append(">");
        this.printProperties(element);
        this.visitChildNotions(element);
        this.printTabs();
        this.myContents.append("</").append(tag).append(">");
        return false;
    }

    public boolean visitParticipant(DesignParticipant participant) throws Exception {
        this.printTabs();
        this.printStartSerializedParticipant(participant);
        this.printProperties(participant);
        this.visitChildNotions(participant);
        this.printTabs();
        this.printEndSerializedParticipant(participant);
        return false;
    }

    public boolean visitReference(DesignReference reference) throws Exception {
        this.printTabs();
        this.myContents.append("<").append("reference").append(" ");
        this.myContents.append(this.prepareProxyAttribute(reference)).append(">");
        this.printProperties(reference);
        this.visitChildNotions(reference);
        this.printTabs();
        this.myContents.append("</").append("reference").append(">");
        return false;
    }

    private void visitChildNotions(DesignNotion notion) {
        ++this.myTabLevel;
        try {
            Iterator childNotions = notion.getChildNotions().iterator();
            while (childNotions.hasNext()) {
                DesignNotion curChild = (DesignNotion)childNotions.next();
                if (curChild.getNodeSet() == notion.getNodeSet()) {
                    curChild.accept(this);
                    continue;
                }
                this.printReferencedNotion(curChild);
            }
        }
        catch (Exception acceptingVisitorFails) {
            acceptingVisitorFails.printStackTrace();
        }
        --this.myTabLevel;
    }

    private void visitMembers(DesignNodeSet nodeSet) {
        ++this.myTabLevel;
        try {
            Iterator members = nodeSet.iterator();
            while (members.hasNext()) {
                DesignElement curMember = (DesignElement)members.next();
                curMember.accept(this);
            }
        }
        catch (Exception acceptingVisitorFails) {
            acceptingVisitorFails.printStackTrace();
        }
        --this.myTabLevel;
    }

    private void printTabs() {
        this.myContents.append("\n");
        int i = 0;
        while (i < this.myTabLevel) {
            this.myContents.append("\t");
            ++i;
        }
    }

    private void printProperties(DesignNotion notion) {
        DesignProperty[] properties = notion.getProperties();
        ++this.myTabLevel;
        int i = 0;
        while (i < properties.length) {
            this.printTabs();
            this.myContents.append("<").append("property").append(" ");
            this.myContents.append("name").append("=");
            this.myContents.append(SerializeVisitor.addQuots(SerializeVisitor.normalize(properties[i].getName()))).append(" ");
            this.myContents.append("value").append("=");
            this.myContents.append(SerializeVisitor.addQuots(SerializeVisitor.normalize(properties[i].getValue()))).append("/>");
            ++i;
        }
        --this.myTabLevel;
    }

    private void printReferencedNotion(DesignNotion notion) {
        this.printTabs();
        this.myContents.append("<").append("refNodeSet").append(" ");
        this.myContents.append("fullPath").append("=");
        this.myContents.append(SerializeVisitor.addQuots(SerializeVisitor.normalize(notion.getNodeSet().getFile().getFullPath().toString())));
        this.myContents.append("/>");
    }

    private static String addQuots(String s) {
        return "\"" + s + "\"";
    }

    private String prepareUinAttribute(DesignElement element) {
        return "uin=" + SerializeVisitor.addQuots(SerializeVisitor.normalize(element.getId()));
    }

    private String prepareProxyAttribute(DesignProxy proxy) {
        return SerializeVisitor.prepareProxyAttribute(proxy.getProxyId());
    }

    private void printStartSerializedParticipant(DesignParticipant participant) {
        String startSerializedParticipant = SerializeVisitor.getStartSerializedParticipant(participant.getProxyId(), participant.getRole());
        this.myContents.append(startSerializedParticipant);
    }

    private void printEndSerializedParticipant(DesignParticipant participant) {
        this.myContents.append("</").append("participant").append(">");
    }

    private static String prepareProxyAttribute(String proxyId) {
        return "referencedUin=" + SerializeVisitor.addQuots(SerializeVisitor.normalize(proxyId));
    }

    public static String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\n': {
                    str.append("&#10;");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public static String denormalize(String s) {
        String lt = SerializeVisitor.replaceInString(s, "&lt;", "<");
        String gt = SerializeVisitor.replaceInString(lt, "&gt;", ">");
        String amp = SerializeVisitor.replaceInString(gt, "&amp;", "&");
        amp = SerializeVisitor.replaceInString(amp, "&#10;", System.getProperty("line.separator"));
        return SerializeVisitor.replaceInString(amp, "&quot;", "\"");
    }

    private static String replaceInString(String source, String pattern, String replace) {
        int curIndex = 0;
        StringBuffer result = new StringBuffer();
        while (true) {
            int nextIndex;
            if ((nextIndex = source.indexOf(pattern, curIndex)) == -1) break;
            result.append(source.substring(curIndex, nextIndex)).append(replace);
            curIndex = nextIndex + pattern.length();
        }
        result.append(source.substring(curIndex));
        return result.toString();
    }

    public boolean visitNodeSet(DesignNodeSet nodeSet) throws Exception {
        this.printTabs();
        this.myContents.append("<").append("nodeSet").append(" ");
        this.myContents.append(this.prepareNodeSetParent(nodeSet)).append(">");
        this.visitMembers(nodeSet);
        this.printTabs();
        this.myContents.append("</").append("nodeSet").append(">");
        return false;
    }

    private String prepareNodeSetParent(DesignNodeSet nodeSet) {
        DesignNode parent = nodeSet.getParent();
        if (parent != null) {
            return "parentUin=" + SerializeVisitor.addQuots(SerializeVisitor.normalize(parent.getId()));
        }
        return "";
    }
}

