/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.io;

import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.io.AbstractReaderState;
import com.tssap.selena.internal.dom.io.NonCrypticDesignFactory;
import com.tssap.selena.internal.dom.io.StatesManager;
import org.xml.sax.Attributes;

public class ReadingNodeState
extends AbstractReaderState {
    private final NodeSetCache myNodeSetCache;

    public ReadingNodeState(StatesManager statesManager, NodeSetCache cache) {
        super(statesManager);
        this.myNodeSetCache = cache;
    }

    private DesignNode getCurrentNode() {
        return (DesignNode)this.peekParsedElement();
    }

    public AbstractReaderState processStartElement(String uri, String localName, String qName, Attributes attributes) {
        AbstractReaderState result = null;
        if ("node".equals(qName) && NonCrypticDesignFactory.canCreateNode(this.getCurrentNode(), attributes)) {
            DesignNode childNode = NonCrypticDesignFactory.createNode(this.getCurrentNode(), attributes);
            this.pushParsedElement(childNode);
            result = this.getStatesManager().READING_NODE_STATE;
        } else if ("link".equals(qName) && NonCrypticDesignFactory.canCreateLink(this.getCurrentNode(), attributes)) {
            DesignLink childLink = NonCrypticDesignFactory.createLink(this.getCurrentNode(), attributes);
            this.pushParsedElement(childLink);
            result = this.getStatesManager().READING_LINK_STATE;
        } else if ("property".equals(qName) && NonCrypticDesignFactory.canCreateProperty(this.getCurrentNode(), attributes)) {
            NonCrypticDesignFactory.createProperty(this.getCurrentNode(), attributes);
            result = this.getStatesManager().READING_PROPERTY_STATE;
        } else if ("refNodeSet".equals(qName) && NonCrypticDesignFactory.canResolveNodeSetFile(attributes)) {
            DesignNodeSet nodeSet = null;
            try {
                nodeSet = NonCrypticDesignFactory.createNodeSet(this.myNodeSetCache, this.getCurrentNode(), attributes);
            }
            catch (Exception loadingNodeSetFails) {
                throw new RuntimeException(loadingNodeSetFails.getMessage());
            }
            result = this.getStatesManager().READING_REFERENCED_NODESET_STATE;
        } else {
            result = this.getStatesManager().SKIPPING_INNERS_STATE;
        }
        return result;
    }

    public void processEndElement(String uri, String localName, String qName) {
        this.popParsedElement();
    }
}

