/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.io;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignParticipant;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IReferenceContainer;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;

public class NonCrypticDesignFactory {
    public static boolean canResolveNodeSetFile(Attributes attributes) {
        return NonCrypticDesignFactory.resolveNodeSetFile(attributes) != null;
    }

    public static DesignNodeSet createNodeSet(NodeSetCache cache, DesignNode parentNode, Attributes attributes) throws Exception {
        IFile nodeSetFile = NonCrypticDesignFactory.resolveNodeSetFile(attributes);
        DesignNodeSet nodeSet = cache.getDesignParser().parse(nodeSetFile);
        return nodeSet;
    }

    public static DesignNodeSet createNodeSet(NodeSetCache cache, IFile file, DesignNode parent, Attributes attributes) {
        String parentId;
        DesignElement mayBeParent;
        if (parent == null && (mayBeParent = cache.getCachedElement(parentId = attributes.getValue("parentUin"))) instanceof DesignNode) {
            parent = (DesignNode)mayBeParent;
        }
        DesignNodeSet result = new DesignNodeSet(file, parent);
        if (parent != null) {
            parent.internalAddChildNodeSet(result);
        }
        return result;
    }

    public static boolean canCreateNodeSet(NodeSetCache cache, IFile file, DesignNode parent, Attributes attributes) {
        DesignElement mayBeParent;
        String parentId = attributes.getValue("parentUin");
        if (parentId == null) {
            return parent == null;
        }
        if (parent == null && (mayBeParent = cache.getCachedElement(parentId)) instanceof DesignNode) {
            parent = (DesignNode)mayBeParent;
        }
        return parent != null && parent.getId().equals(parentId);
    }

    private static IFile resolveNodeSetFile(Attributes attributes) {
        String pathAsString = attributes.getValue("fullPath");
        if (pathAsString == null) {
            return null;
        }
        IFile result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pathAsString));
        if (!result.exists()) {
            return null;
        }
        return result;
    }

    public static boolean canCreateNode(DesignNodeSet nodeSet, Attributes attributes) {
        return NonCrypticDesignFactory.isNotUsedUin(nodeSet, attributes);
    }

    public static DesignNode createNode(DesignNodeSet nodeSet, Attributes attributes) {
        String uin = attributes.getValue("uin");
        DesignNode result = new DesignNode(null, uin, nodeSet);
        nodeSet.internalAddMember(result);
        return result;
    }

    public static boolean canCreateNode(DesignNode parent, Attributes attributes) {
        return NonCrypticDesignFactory.isNotUsedUin(parent.getChildren(), attributes);
    }

    public static DesignNode createNode(DesignNode parent, Attributes attributes) {
        String newUin = attributes.getValue("uin");
        if (parent == null) {
            return new DesignNode(null, newUin, null);
        }
        return parent.internalCreateChildNode(newUin);
    }

    public static boolean canCreateLink(DesignNode parent, Attributes attributes) {
        return parent != null && NonCrypticDesignFactory.isNotUsedUin(parent.getChildren(), attributes);
    }

    public static DesignLink createLink(DesignNode parent, Attributes attributes) {
        String newUin = attributes.getValue("uin");
        return parent.internalCreateChildLink(newUin);
    }

    public static boolean canCreateView(DesignNodeSet nodeSet, Attributes attributes) {
        return nodeSet.getParent() == null && NonCrypticDesignFactory.isNotUsedUin(nodeSet, attributes);
    }

    public static DesignView createView(DesignNodeSet nodeSet, Attributes attributes) {
        String uin = attributes.getValue("uin");
        DesignView result = new DesignView(null, uin, nodeSet);
        nodeSet.internalAddMember(result);
        return result;
    }

    public static boolean canCreateProperty(DesignNotion owner, Attributes attributes) {
        String value = attributes.getValue("value");
        String name = attributes.getValue("name");
        return value != null && name != null;
    }

    public static DesignProperty createProperty(DesignNotion owner, Attributes attributes) {
        String value = attributes.getValue("value");
        String name = attributes.getValue("name");
        return owner.internalCreateProperty(name, value);
    }

    public static boolean canCreateParticipant(DesignLink link, Attributes attributes) {
        String role = attributes.getValue("role");
        String proxyId = attributes.getValue("referencedUin");
        if (proxyId == null) {
            return false;
        }
        return "Client".equals(role) || "Supplier".equals(role);
    }

    public static DesignParticipant createParticipant(DesignLink link, Attributes attributes) {
        String proxyId = attributes.getValue("referencedUin");
        String role = attributes.getValue("role");
        if ("Client".equals(role)) {
            return link.internalCreateSource(proxyId);
        }
        return link.internalCreateTarget(proxyId);
    }

    public static boolean canCreateReference(IReferenceContainer container, Attributes attributes) {
        String proxyId = attributes.getValue("referencedUin");
        if (proxyId == null) {
            return false;
        }
        DesignReference[] alreadyCreated = container.getReferences();
        int i = 0;
        while (i < alreadyCreated.length) {
            if (proxyId.equals(alreadyCreated[i].getProxyId())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static DesignReference createReference(IReferenceContainer container, Attributes attributes) {
        String proxyId = attributes.getValue("referencedUin");
        return container.internalAddReference(proxyId);
    }

    private static boolean isNotUsedUin(DesignNodeSet nodeSet, Attributes attributes) {
        String uin = attributes.getValue("uin");
        if (uin == null) {
            return false;
        }
        Iterator members = nodeSet.iterator();
        while (members.hasNext()) {
            if (!uin.equals(((DesignElement)members.next()).getId())) continue;
            return false;
        }
        DesignNode parent = nodeSet.getParent();
        return parent == null || NonCrypticDesignFactory.isNotUsedUin(parent.getChildren(), attributes);
    }

    private static boolean isNotUsedUin(DesignElement[] siblings, Attributes attributes) {
        String uin = attributes.getValue("uin");
        if (uin == null) {
            return false;
        }
        int i = 0;
        while (i < siblings.length) {
            if (uin.equals(siblings[i].getId())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

