/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.compare;

import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.internal.dom.compare.PropertyComparator;
import java.util.HashMap;
import java.util.Iterator;

public class ViewChildrenComparator {
    public static boolean haveEqualReferences(DesignView oldView, DesignView newView) {
        if (oldView == null || newView == null) {
            throw new NullPointerException("Either the old or the new state is null");
        }
        if (!oldView.getId().equals(newView.getId())) {
            throw new IllegalArgumentException("Elements being diffed have unequal ids");
        }
        HashMap oldReferences = ViewChildrenComparator.createReferencesMap(oldView);
        HashMap newReferences = ViewChildrenComparator.createReferencesMap(newView);
        if (oldReferences.size() != newReferences.size()) {
            return false;
        }
        Iterator it = oldReferences.keySet().iterator();
        while (it.hasNext()) {
            String proxyId = (String)it.next();
            DesignReference oldChild = (DesignReference)oldReferences.get(proxyId);
            DesignReference newChild = (DesignReference)newReferences.get(proxyId);
            if (newChild == null) {
                return false;
            }
            if (PropertyComparator.hasEqualProperties(oldChild, newChild)) continue;
            return false;
        }
        return true;
    }

    private static HashMap createReferencesMap(DesignView view) {
        HashMap<String, DesignReference> result = new HashMap<String, DesignReference>();
        DesignReference[] children = view.getReferences();
        int i = 0;
        while (i < children.length) {
            DesignReference child = children[i];
            result.put(child.getProxyId(), child);
            ++i;
        }
        return result;
    }
}

