/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.compare;

import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.internal.dom.compare.HashBag;
import java.util.Iterator;
import java.util.List;

public class PropertyComparator {
    public static boolean hasEqualProperties(DesignNotion oldState, DesignNotion newState) {
        DesignProperty[] newProperties;
        if (oldState == null || newState == null) {
            throw new NullPointerException("Either the old or the new state is null");
        }
        DesignProperty[] oldProperties = oldState.getProperties();
        if (oldProperties.length != (newProperties = newState.getProperties()).length) {
            return false;
        }
        HashBag oldBag = PropertyComparator.createPropertiesBag(oldProperties);
        HashBag newBag = PropertyComparator.createPropertiesBag(newProperties);
        Iterator it = oldBag.keys();
        while (it.hasNext()) {
            String nextKey = (String)it.next();
            List oldValues = oldBag.getValues(nextKey);
            List newValues = newBag.getValues(nextKey);
            if (oldValues.size() != newValues.size()) {
                return false;
            }
            Iterator valuesIt = oldValues.iterator();
            while (valuesIt.hasNext()) {
                String value = (String)valuesIt.next();
                int indexOfValue = newValues.indexOf(value);
                if (indexOfValue == -1) {
                    return false;
                }
                valuesIt.remove();
                newValues.remove(indexOfValue);
            }
        }
        return true;
    }

    private static HashBag createPropertiesBag(DesignProperty[] properties) {
        HashBag result = new HashBag();
        int i = 0;
        while (i < properties.length) {
            DesignProperty property = properties[i];
            result.put(property.getName(), property.getValue());
            ++i;
        }
        return result;
    }
}

