/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom.compare;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AbstractChildrenComparator {
    private Collection myAddedChildren = new HashSet();
    private Collection myRemovedChildren = new HashSet();
    private HashMap myPairedChildren = new HashMap();

    public AbstractChildrenComparator(Object oldNode, Object newNode) {
        this.diffNodes(oldNode, newNode);
    }

    private void diffNodes(Object oldNode, Object newNode) {
        if (oldNode == null || newNode == null) {
            throw new NullPointerException("Either the old or the new state is null");
        }
        HashMap oldChildren = this.createChildrenMap(oldNode);
        HashMap newChildren = this.createChildrenMap(newNode);
        Iterator it = oldChildren.keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            Object oldChild = oldChildren.get(id);
            Object newChild = newChildren.get(id);
            if (newChild == null) {
                this.myRemovedChildren.add(oldChild);
            } else if (!oldChild.getClass().equals(newChild.getClass())) {
                this.myRemovedChildren.add(oldChild);
                this.myAddedChildren.add(newChild);
            } else {
                this.myPairedChildren.put(oldChild, newChild);
            }
            it.remove();
            newChildren.remove(id);
        }
        Iterator it2 = newChildren.values().iterator();
        while (it2.hasNext()) {
            this.myAddedChildren.add(it2.next());
        }
    }

    public abstract HashMap createChildrenMap(Object var1);

    public Collection getAddedChildren() {
        return this.myAddedChildren;
    }

    public Collection getRemovedChildren() {
        return this.myRemovedChildren;
    }

    public HashMap getPairedChildren() {
        return this.myPairedChildren;
    }
}

