/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IReferenceContainer;
import com.tssap.selena.dom.Revisit;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.AbstractDeltaNode;
import com.tssap.selena.internal.dom.AddedElementDelta;
import com.tssap.selena.internal.dom.DeletedElementDelta;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.internal.dom.IDesignTreeDeltaListener;
import com.tssap.selena.internal.dom.PackageDeltaNode;
import com.tssap.selena.internal.dom.RegularElementDelta;
import com.tssap.selena.internal.dom.TotallyChangedDelta;
import com.tssap.selena.internal.dom.compare.LinkChildrenComparator;
import com.tssap.selena.internal.dom.compare.NodeChildrenComparator;
import com.tssap.selena.internal.dom.compare.NodeSetComparator;
import com.tssap.selena.internal.dom.compare.PropertyComparator;
import com.tssap.selena.internal.dom.compare.ReferenceContainerChildrenComparator;
import com.tssap.selena.internal.dom.compare.ViewChildrenComparator;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class TreeDeltaBuilder {
    private UniqueName myModelUin;
    private PackageDeltaNode myRootDeltaNode;
    private HashSet myListeners = new HashSet();
    private HashMap myDesignDeltaNodes = new HashMap();
    private HashMap myPackageDeltaNodes = new HashMap();

    public TreeDeltaBuilder(UniqueName modelUin) {
        this.myModelUin = modelUin;
        this.reinitialize();
    }

    public void reinitialize() {
        this.myDesignDeltaNodes.clear();
        this.myPackageDeltaNodes.clear();
        this.myRootDeltaNode = new PackageDeltaNode(this.getModel(), (Element)this.getModel());
    }

    public ModelDeltaNode getRootDelta() {
        return this.myRootDeltaNode;
    }

    public void addDeltaListener(IDesignTreeDeltaListener listener) {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.add(listener);
        }
    }

    public void removeDeltaListener(IDesignTreeDeltaListener listener) {
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            this.myListeners.remove(listener);
        }
    }

    void notifyListeners() {
        if (this.isEmpty()) {
            return;
        }
        HashSet hashSet = this.myListeners;
        synchronized (hashSet) {
            Iterator it = this.myListeners.iterator();
            while (it.hasNext()) {
                ((IDesignTreeDeltaListener)it.next()).update(this);
            }
        }
    }

    public void registerAdded(DesignNodeSet nodeSet) {
        Iterator members = nodeSet.iterator();
        while (members.hasNext()) {
            this.registerAdded((DesignElement)members.next());
        }
    }

    public void registerRemoved(DesignNodeSet nodeSet) {
        Iterator members = nodeSet.iterator();
        while (members.hasNext()) {
            this.registerRemoved((DesignElement)members.next());
        }
    }

    public void registerAdded(DesignElement element) {
        UniqueName uin = NameUtil.getUniqueName(element);
        AbstractDeltaNode existingNode = (AbstractDeltaNode)this.myDesignDeltaNodes.get(uin);
        if (existingNode == null) {
            AddedElementDelta addedNode = new AddedElementDelta(null, this.getModel(), element);
            this.coupleToRootDelta(addedNode);
            return;
        }
        if (existingNode.isNew()) {
            return;
        }
        if (existingNode.isDeleted()) {
            this.replaceByTotallyChangedDelta(existingNode, uin, element);
        }
    }

    private void replaceByTotallyChangedDelta(AbstractDeltaNode existingDelta, UniqueName uin, DesignElement designElement) {
        if (existingDelta == null || existingDelta.getParent() == null) {
            return;
        }
        existingDelta.getParent().removeChildDelta(existingDelta);
        TotallyChangedDelta replacedOne = new TotallyChangedDelta(null, this.getModel(), designElement);
        existingDelta.getParent().addChildDelta(replacedOne);
        this.myDesignDeltaNodes.put(uin, replacedOne);
    }

    public void registerRemoved(DesignElement element) {
        UniqueName uin = NameUtil.getUniqueName(element);
        if (this.myDesignDeltaNodes.containsKey(uin)) {
            AbstractDeltaNode existingNode = (AbstractDeltaNode)this.myDesignDeltaNodes.get(uin);
            if (existingNode.getParent() == null) {
                return;
            }
            if (existingNode.isNew()) {
                this.replaceByTotallyChangedDelta(existingNode, uin, element);
                return;
            }
            existingNode.getParent().removeChildDelta(existingNode);
            this.myDesignDeltaNodes.remove(uin);
        }
        DeletedElementDelta deletedNode = new DeletedElementDelta(null, this.getModel(), element);
        this.coupleToRootDelta(deletedNode);
    }

    public void registerChanged(DesignElement element) {
        UniqueName uin = NameUtil.getUniqueName(element);
        AbstractDeltaNode changedNode = (AbstractDeltaNode)this.myDesignDeltaNodes.get(uin);
        if (changedNode == null) {
            changedNode = new RegularElementDelta(null, this.getModel(), element, true);
            this.coupleToRootDelta(changedNode);
        } else {
            Revisit.fixNotify();
            changedNode.registerChanged();
        }
    }

    public void registerChanged(DesignNotion notion) {
        this.registerChanged(TreeDeltaBuilder.getParentElement(notion));
    }

    private static DesignElement getParentElement(DesignNotion notion) {
        if (notion instanceof DesignElement) {
            return (DesignElement)notion;
        }
        return TreeDeltaBuilder.getParentElement(notion.getParent());
    }

    void fileAdded(IFile file) {
        DesignNodeSet oldState = this.getCache().dropNodeSet(file);
        DesignNodeSet newState = this.getCache().parse(file);
        if (this.checkFileParentExistsInModel(file)) {
            this.diffNodeSets(oldState, newState);
        }
    }

    void fileRemoved(IFile file) {
        DesignNodeSet deletedNodeSet = this.getCache().dropNodeSet(file);
        if (deletedNodeSet == null) {
            return;
        }
        if (this.checkFileParentExistsInModel(file)) {
            this.registerRemoved(deletedNodeSet);
        }
    }

    void fileModified(IFile file) {
        DesignNodeSet oldState = this.getCache().dropNodeSet(file);
        if (oldState == null) {
            return;
        }
        DesignNodeSet newState = this.getCache().parse(file);
        if (this.checkFileParentExistsInModel(file)) {
            this.diffNodeSets(oldState, newState);
        }
    }

    private boolean checkFileParentExistsInModel(IFile file) {
        UniqueName folderRepresentationUin = DesignRootAccess.getInstance(file.getProject()).findResourceElementUin(file.getParent());
        if (folderRepresentationUin == null) {
            return false;
        }
        Entity modelFolder = this.getModel().findEntity(folderRepresentationUin);
        if (modelFolder == null) {
            return false;
        }
        return !modelFolder.isDeleted();
    }

    private void diffElements(DesignElement oldState, DesignElement newState) {
        if (!PropertyComparator.hasEqualProperties(oldState, newState)) {
            this.registerChanged(newState);
        }
        if (oldState instanceof DesignLink) {
            this.diffLinks((DesignLink)oldState, (DesignLink)newState);
        } else if (oldState instanceof DesignView) {
            this.diffViews((DesignView)oldState, (DesignView)newState);
        } else {
            this.diffNodes((DesignNode)oldState, (DesignNode)newState);
        }
    }

    private void diffLinks(DesignLink oldLink, DesignLink newLink) {
        if (!LinkChildrenComparator.haveEqualParticipants(oldLink, newLink)) {
            this.registerChanged(newLink);
        }
    }

    private void diffViews(DesignView oldView, DesignView newView) {
        if (!ViewChildrenComparator.haveEqualReferences(oldView, newView)) {
            this.registerChanged(newView);
        }
        this.diffReferenceContainers(oldView, newView);
    }

    private void diffReferenceContainers(IReferenceContainer oldContainer, IReferenceContainer newContainer) {
        ReferenceContainerChildrenComparator comparator = new ReferenceContainerChildrenComparator(oldContainer, newContainer);
        Iterator it = comparator.getAddedChildren().iterator();
        while (it.hasNext()) {
            this.getCache().referenceAdded((DesignReference)it.next());
        }
        Iterator it2 = comparator.getRemovedChildren().iterator();
        while (it2.hasNext()) {
            this.getCache().referenceDeleted((DesignReference)it2.next());
        }
        HashMap pairs = comparator.getPairedChildren();
        Iterator it3 = pairs.keySet().iterator();
        while (it3.hasNext()) {
            DesignReference newState;
            DesignReference oldState = (DesignReference)it3.next();
            if (!PropertyComparator.hasEqualProperties(oldState, newState = (DesignReference)pairs.get(oldState))) {
                this.getCache().referenceChanged(newState);
            }
            this.diffReferenceContainers(oldState, newState);
        }
    }

    private void diffNodeSets(DesignNodeSet oldNodeSet, DesignNodeSet newNodeSet) {
        if (oldNodeSet == null && newNodeSet == null) {
            return;
        }
        if (oldNodeSet == null) {
            this.registerAdded(newNodeSet);
            return;
        }
        if (newNodeSet == null) {
            this.registerRemoved(oldNodeSet);
            return;
        }
        NodeSetComparator comparator = new NodeSetComparator(oldNodeSet, newNodeSet);
        Iterator it = comparator.getAddedChildren().iterator();
        while (it.hasNext()) {
            this.registerAdded((DesignElement)it.next());
        }
        Iterator it2 = comparator.getRemovedChildren().iterator();
        while (it2.hasNext()) {
            this.registerRemoved((DesignElement)it2.next());
        }
        HashMap pairs = comparator.getPairedChildren();
        Iterator it3 = pairs.keySet().iterator();
        while (it3.hasNext()) {
            DesignElement oldState = (DesignElement)it3.next();
            DesignElement newState = (DesignElement)pairs.get(oldState);
            this.diffElements(oldState, newState);
        }
    }

    private void diffNodes(DesignNode oldNode, DesignNode newNode) {
        NodeChildrenComparator comparator = new NodeChildrenComparator(oldNode, newNode);
        Iterator it = comparator.getAddedChildren().iterator();
        while (it.hasNext()) {
            this.registerAdded((DesignElement)it.next());
        }
        Iterator it2 = comparator.getRemovedChildren().iterator();
        while (it2.hasNext()) {
            this.registerRemoved((DesignElement)it2.next());
        }
        HashMap pairs = comparator.getPairedChildren();
        Iterator it3 = pairs.keySet().iterator();
        while (it3.hasNext()) {
            DesignElement oldState = (DesignElement)it3.next();
            DesignElement newState = (DesignElement)pairs.get(oldState);
            this.diffElements(oldState, newState);
        }
    }

    private NodeSetCache getCache() {
        return NodeSetCache.getCache(this.myModelUin);
    }

    private PackageDeltaNode getPackageDeltaNode(Element folder) {
        if (folder instanceof Model) {
            return this.myRootDeltaNode;
        }
        PackageDeltaNode node = (PackageDeltaNode)this.myPackageDeltaNodes.get(folder.getUniqueName());
        if (node == null) {
            node = new PackageDeltaNode(this.getModel(), folder);
            Entity parentFolder = folder.getParent();
            PackageDeltaNode parentNode = this.getPackageDeltaNode((Element)parentFolder);
            parentNode.addChildDelta(node);
            this.myPackageDeltaNodes.put(folder.getUniqueName(), node);
        }
        return node;
    }

    private void coupleToRootDelta(AbstractDeltaNode detachedDelta) {
        UniqueName detachedUin = detachedDelta.getElementUniqueName();
        DesignElement detachedReferent = detachedDelta.getReferent();
        if (this.myDesignDeltaNodes.containsKey(detachedUin)) {
            throw new IllegalStateException("TreeDeltaBuilder: attempt to couple delta with already known referent");
        }
        DesignElement referentParent = (DesignElement)detachedReferent.getParent();
        this.myDesignDeltaNodes.put(detachedUin, detachedDelta);
        if (referentParent == null) {
            IContainer fileParent = detachedReferent.getFile().getParent();
            UniqueName folderCounterpartUin = DesignRootAccess.getInstance(fileParent.getProject()).findResourceElementUin(fileParent);
            if (folderCounterpartUin == null) {
                throw new RuntimeException("parent folder is not represented in the model");
            }
            Element folderCounterpart = this.getModel().findElement(folderCounterpartUin);
            if (folderCounterpart == null) {
                throw new RuntimeException("parent folder is not represented in the model");
            }
            this.getPackageDeltaNode(folderCounterpart).addChildDelta(detachedDelta);
        } else {
            AbstractDeltaNode mayBeExistingDeltaNode = (AbstractDeltaNode)this.myDesignDeltaNodes.get(NameUtil.getUniqueName(referentParent));
            if (mayBeExistingDeltaNode == null) {
                RegularElementDelta oneLevelUpDelta = new RegularElementDelta(null, this.getModel(), referentParent, false);
                oneLevelUpDelta.addChildDelta(detachedDelta);
                this.coupleToRootDelta(oneLevelUpDelta);
            } else {
                mayBeExistingDeltaNode.addChildDelta(detachedDelta);
            }
        }
    }

    private Model getModel() {
        return ModelAccess.getModel((UniqueName)this.myModelUin);
    }

    private IProject getProject() {
        return ModelUinSupport.getProject((UniqueName)this.myModelUin);
    }

    private boolean isEmpty() {
        Revisit.fixNotify();
        return false;
    }
}

