/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.DOMPlugin;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ResourceListener
implements IResourceChangeListener {
    private IResourceDeltaVisitor myDeltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource == null) {
                return false;
            }
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    if (ResourceListener.this.isProjectBeingOpened(delta)) {
                        return false;
                    }
                    if (ResourceListener.this.isProjectBeingClosed(delta)) {
                        ResourceListener.this.myProjectsBeingClosed.add(resource.getName());
                        return false;
                    }
                    if (ResourceListener.this.isProjectNatureChanged(delta)) {
                        ResourceListener.this.myProjectsBeingClosed.add(resource.getName());
                        return false;
                    }
                    ResourceListener.this.myAffectedProjects.add(resource.getName());
                    return true;
                }
                case 2: {
                    if (delta.getKind() == 1 || delta.getKind() == 2) {
                        // empty if block
                    }
                    return true;
                }
                case 1: {
                    ResourceListener.this.processFileModification(delta);
                }
            }
            return false;
        }
    };
    private List myProjectsBeingClosed = new LinkedList();
    private List myAffectedProjects = new LinkedList();
    private HashMap myProcessedRenamings = new HashMap(5);

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resourceChanged(IResourceChangeEvent event) {
        block25: {
            block24: {
                block29: {
                    block23: {
                        block28: {
                            block22: {
                                try {
                                    try {
                                        block27: {
                                            block26: {
                                                if (event == null || event.getDelta() == null) break block26;
                                                if (event.getType() == 1) break block27;
                                            }
                                            var4_2 = null;
                                            this.myProcessedRenamings.clear();
                                            break block22;
                                        }
                                        this.myProcessedRenamings.clear();
                                        event.getDelta().accept(this.myDeltaVisitor);
                                        break block23;
                                    }
                                    catch (CoreException resourceException) {
                                        DOMPlugin.getDefault().logException((Exception)resourceException);
                                        var4_4 = null;
                                        this.myProcessedRenamings.clear();
                                        try {
                                            it = this.myAffectedProjects.iterator();
                                            while (true) {
                                                if (!it.hasNext()) {
                                                    v0 = null;
                                                    break block24;
                                                }
                                                curProjectId = (String)it.next();
                                                curModelUin = ModelUinSupport.createModelUin((String)curProjectId);
                                                NodeSetCache.getCache(curModelUin).getTreeDeltaBuilder().notifyListeners();
                                            }
                                        }
                                        catch (Throwable var8_20) {
                                            v0 = null;
                                            break block24;
                                        }
                                    }
                                }
                                catch (Throwable var3_39) {
                                    var4_5 = null;
                                    this.myProcessedRenamings.clear();
                                    ** try [egrp 2[TRYBLOCK] [2 : 85->145)] { 
lbl38:
                                    // 1 sources

                                    it = this.myAffectedProjects.iterator();
                                    while (true) {
                                        if (!it.hasNext()) {
                                            v1 = null;
                                            break block25;
                                        }
                                        curProjectId = (String)it.next();
                                        curModelUin = ModelUinSupport.createModelUin((String)curProjectId);
                                        NodeSetCache.getCache(curModelUin).getTreeDeltaBuilder().notifyListeners();
                                    }
lbl47:
                                    // 1 sources

                                    catch (Throwable var8_21) {
                                        v1 = null;
                                        break block25;
                                    }
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [2 : 85->145)] { 
lbl52:
                            // 1 sources

                            it = this.myAffectedProjects.iterator();
                            while (it.hasNext()) {
                                curProjectId = (String)it.next();
                                curModelUin = ModelUinSupport.createModelUin((String)curProjectId);
                                NodeSetCache.getCache(curModelUin).getTreeDeltaBuilder().notifyListeners();
                            }
                            v2 = null;
                            break block28;
lbl60:
                            // 1 sources

                            catch (Throwable var8_18) {
                                v2 = null;
                            }
                        }
                        var9_22 = v2;
                        this.myAffectedProjects = new LinkedList<E>();
                        it = this.myProjectsBeingClosed.iterator();
                        while (true) {
                            if (!it.hasNext()) break;
                            curClosingProjectId = (String)it.next();
                            curModelUin = ModelUinSupport.createModelUin((String)curClosingProjectId);
                        }
                        this.myProjectsBeingClosed = new LinkedList<E>();
                        return;
                    }
                    var4_3 = null;
                    this.myProcessedRenamings.clear();
                    ** try [egrp 2[TRYBLOCK] [2 : 85->145)] { 
lbl77:
                    // 1 sources

                    it = this.myAffectedProjects.iterator();
                    while (it.hasNext()) {
                        curProjectId = (String)it.next();
                        curModelUin = ModelUinSupport.createModelUin((String)curProjectId);
                        NodeSetCache.getCache(curModelUin).getTreeDeltaBuilder().notifyListeners();
                    }
                    v3 = null;
                    break block29;
lbl85:
                    // 1 sources

                    catch (Throwable var8_19) {
                        v3 = null;
                    }
                }
                var9_23 = v3;
                this.myAffectedProjects = new LinkedList<E>();
                it = this.myProjectsBeingClosed.iterator();
                while (true) {
                    if (!it.hasNext()) break;
                    curClosingProjectId = (String)it.next();
                    curModelUin = ModelUinSupport.createModelUin((String)curClosingProjectId);
                }
                this.myProjectsBeingClosed = new LinkedList<E>();
                return;
            }
            var9_24 = v0;
            this.myAffectedProjects = new LinkedList<E>();
            it = this.myProjectsBeingClosed.iterator();
            while (true) {
                if (!it.hasNext()) break;
                curClosingProjectId = (String)it.next();
                curModelUin = ModelUinSupport.createModelUin((String)curClosingProjectId);
            }
            this.myProjectsBeingClosed = new LinkedList<E>();
            return;
        }
        var9_25 = v1;
        this.myAffectedProjects = new LinkedList<E>();
        it = this.myProjectsBeingClosed.iterator();
        while (true) {
            if (!it.hasNext()) {
                this.myProjectsBeingClosed = new LinkedList<E>();
                throw var3_39;
            }
            curClosingProjectId = (String)it.next();
            curModelUin = ModelUinSupport.createModelUin((String)curClosingProjectId);
        }
    }

    private boolean isProjectBeingOpened(IResourceDelta delta) {
        if (delta == null || !(delta.getResource() instanceof IProject)) {
            return false;
        }
        switch (delta.getKind()) {
            case 1: {
                return true;
            }
            case 4: {
                return delta.getResource().isAccessible() && (delta.getFlags() & 0x4000) > 0;
            }
        }
        return false;
    }

    private boolean isProjectBeingClosed(IResourceDelta delta) {
        if (delta == null || !(delta.getResource() instanceof IProject)) {
            return false;
        }
        switch (delta.getKind()) {
            case 2: {
                return true;
            }
            case 4: {
                return !delta.getResource().isAccessible() && (delta.getFlags() & 0x4000) > 0;
            }
        }
        return false;
    }

    private boolean isProjectNatureChanged(IResourceDelta delta) {
        if (delta == null || !(delta.getResource() instanceof IProject)) {
            return false;
        }
        if (delta.getKind() == 4) {
            return ((IProject)delta.getResource()).isOpen() && (delta.getFlags() & 0x80000) > 0;
        }
        return false;
    }

    private void processFileModification(IResourceDelta delta) {
        IFile changedFile = (IFile)delta.getResource();
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)changedFile);
        NodeSetCache cache = NodeSetCache.getCache(modelUin);
        if (!cache.getNamingStrategy().isNodeSetFile((IResource)changedFile)) {
            return;
        }
        if (cache.isFileChangesAlreadyProcessed(changedFile)) {
            cache.setFileChangesAlreadyProcessed(changedFile, false);
            return;
        }
        if (this.processRenaming(cache, delta)) {
            return;
        }
        switch (delta.getKind()) {
            case 4: {
                cache.getTreeDeltaBuilder().fileModified(changedFile);
                break;
            }
            case 2: {
                cache.getTreeDeltaBuilder().fileRemoved(changedFile);
                break;
            }
            case 1: {
                cache.getTreeDeltaBuilder().fileAdded(changedFile);
            }
        }
    }

    private boolean processRenaming(NodeSetCache cache, IResourceDelta delta) {
        IPath oldFullPath = null;
        IPath newFullPath = null;
        if (delta.getKind() == 1 && (delta.getFlags() & 0x1000) > 0) {
            oldFullPath = delta.getMovedFromPath();
            newFullPath = delta.getFullPath();
        } else if (delta.getKind() == 2 && (delta.getFlags() & 0x2000) > 0) {
            oldFullPath = delta.getFullPath();
            newFullPath = delta.getMovedToPath();
        }
        if (oldFullPath == null || newFullPath == null || oldFullPath.equals((Object)newFullPath)) {
            return false;
        }
        IFile oldFileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(oldFullPath);
        IFile newFileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(newFullPath);
        Assert.isLegal((oldFileHandle != null && newFileHandle != null ? 1 : 0) != 0);
        if (!oldFileHandle.getProject().equals((Object)newFileHandle.getProject())) {
            return false;
        }
        if (this.myProcessedRenamings.containsKey(oldFullPath)) {
            return true;
        }
        this.myProcessedRenamings.put(oldFullPath, newFullPath);
        cache.dropNodeSet(oldFileHandle);
        DesignNodeSet renamedNodeSet = cache.parse(newFileHandle);
        if (renamedNodeSet != null) {
            Iterator members = renamedNodeSet.iterator();
            while (members.hasNext()) {
                cache.getTreeDeltaBuilder().registerChanged((DesignElement)members.next());
            }
        }
        return true;
    }
}

