/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom;

import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.internal.providers.resources.root.UniqueNameUtil;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.delta.CompositeModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class MovedDiagramDeltaProvider
extends AbstractDesignProvider
implements DeltaTreeProvider {
    private static Map ourRegisteredInstances = new HashMap();
    private CompositeModelDeltaNode myCollectedDelta;
    static /* synthetic */ Class class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider;

    public static void diagramMoved(Model model, IRootRelativePath oldFolderPath, UniqueName oldDiagramUin, IRootRelativePath newFolderPath, UniqueName newDiagramUin, boolean markPackagesMoved) {
        if (model == null || oldFolderPath == null || oldDiagramUin == null || newFolderPath == null || newDiagramUin == null) {
            return;
        }
        Class clazz = class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider == null ? (class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider = MovedDiagramDeltaProvider.class$("com.tssap.selena.internal.dom.MovedDiagramDeltaProvider")) : class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider;
        synchronized (clazz) {
            MovedDiagramDeltaProvider provider = (MovedDiagramDeltaProvider)ourRegisteredInstances.get(model.getUniqueName());
            if (provider == null) {
                return;
            }
            provider.attachDelta(oldFolderPath, oldDiagramUin, newFolderPath, newDiagramUin, markPackagesMoved);
        }
    }

    public void registered(Model model) {
        Class clazz = class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider == null ? (class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider = MovedDiagramDeltaProvider.class$("com.tssap.selena.internal.dom.MovedDiagramDeltaProvider")) : class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider;
        synchronized (clazz) {
            super.registered(model);
            ourRegisteredInstances.put(model.getUniqueName(), this);
        }
    }

    public void unregistered(Model model) {
        Class clazz = class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider == null ? (class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider = MovedDiagramDeltaProvider.class$("com.tssap.selena.internal.dom.MovedDiagramDeltaProvider")) : class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider;
        synchronized (clazz) {
            ourRegisteredInstances.remove(model.getUniqueName());
            super.unregistered(model);
        }
    }

    public ModelDeltaNode getModelChanges() {
        Class clazz = class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider == null ? (class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider = MovedDiagramDeltaProvider.class$("com.tssap.selena.internal.dom.MovedDiagramDeltaProvider")) : class$com$tssap$selena$internal$dom$MovedDiagramDeltaProvider;
        synchronized (clazz) {
            CompositeModelDeltaNode result = this.myCollectedDelta;
            this.myCollectedDelta = null;
            CompositeModelDeltaNode compositeModelDeltaNode = result;
            return compositeModelDeltaNode;
        }
    }

    private void attachDelta(IRootRelativePath oldFolderPath, UniqueName oldDiagramUin, IRootRelativePath newFolderPath, UniqueName newDiagramUin, boolean markPackagesMoved) {
        ModelDeltaNode newDelta = this.buildDelta(oldFolderPath, oldDiagramUin, newFolderPath, newDiagramUin, markPackagesMoved);
        if (newDelta == null) {
            return;
        }
        if (this.myCollectedDelta == null) {
            this.myCollectedDelta = new CompositeModelDeltaNode(this.getModel());
        }
        this.myCollectedDelta.addNode(newDelta);
        this.getModel().getExtensionManager().modelContentsChanged();
    }

    private ModelDeltaNode buildDelta(IRootRelativePath oldFolderPath, UniqueName oldDiagramUin, IRootRelativePath newFolderPath, UniqueName newDiagramUin, boolean markPackagesMoved) {
        if (oldFolderPath.segmentCount() == 0 || newFolderPath.segmentCount() == 0) {
            return null;
        }
        SimpleDeltaNode rootDelta = new SimpleDeltaNode(this.getModel(), this.getModelUin(), null, ModelDeltaNodeKind.UNKNOWN);
        SimpleDeltaNode deletedPart = this.buildDeletedPart(oldFolderPath, oldDiagramUin, newFolderPath, newDiagramUin, markPackagesMoved);
        SimpleDeltaNode newPart = this.buildNewPart(oldFolderPath, oldDiagramUin, newFolderPath, newDiagramUin, markPackagesMoved);
        rootDelta.addChild(deletedPart);
        rootDelta.addChild(newPart);
        return rootDelta;
    }

    private SimpleDeltaNode buildDeletedPart(IRootRelativePath oldFolderPath, UniqueName oldDiagramUin, IRootRelativePath newFolderPath, UniqueName newDiagramUin, boolean markPackagesMoved) {
        Assert.isLegal((oldFolderPath != null && oldFolderPath.segmentCount() != 0 ? 1 : 0) != 0);
        Assert.isLegal((newFolderPath != null && newFolderPath.segmentCount() != 0 ? 1 : 0) != 0);
        Assert.isLegal((oldDiagramUin != null && newDiagramUin != null ? 1 : 0) != 0);
        SimpleDeltaNode bottom = new SimpleDeltaNode(this.getModel(), oldDiagramUin, newDiagramUin, ModelDeltaNodeKind.DELETED);
        int i = 0;
        while (i < oldFolderPath.segmentCount()) {
            IPath curPath = oldFolderPath.removeLastSegments(i);
            boolean isCommonInOldAndNew = curPath.isPrefixOf((IPath)newFolderPath);
            ModelDeltaNodeKind curKind = markPackagesMoved && !isCommonInOldAndNew ? ModelDeltaNodeKind.DELETED : ModelDeltaNodeKind.UNKNOWN;
            SimpleDeltaNode next = new SimpleDeltaNode(this.getModel(), curPath, (IPath)(i == 0 ? newFolderPath : null), curKind);
            next.addChild(bottom);
            bottom = next;
            ++i;
        }
        return bottom;
    }

    private SimpleDeltaNode buildNewPart(IRootRelativePath oldFolderPath, UniqueName oldDiagramUin, IRootRelativePath newFolderPath, UniqueName newDiagramUin, boolean markPackagesMoved) {
        Assert.isLegal((oldFolderPath != null && oldFolderPath.segmentCount() != 0 ? 1 : 0) != 0);
        Assert.isLegal((newFolderPath != null && newFolderPath.segmentCount() != 0 ? 1 : 0) != 0);
        Assert.isLegal((oldDiagramUin != null && newDiagramUin != null ? 1 : 0) != 0);
        SimpleDeltaNode bottom = new SimpleDeltaNode(this.getModel(), newDiagramUin, oldDiagramUin, ModelDeltaNodeKind.NEW);
        int i = 0;
        while (i < newFolderPath.segmentCount()) {
            IPath curPath = newFolderPath.removeLastSegments(i);
            boolean isCommonInOldAndNew = curPath.isPrefixOf((IPath)oldFolderPath);
            ModelDeltaNodeKind curKind = markPackagesMoved && !isCommonInOldAndNew ? ModelDeltaNodeKind.NEW : ModelDeltaNodeKind.UNKNOWN;
            SimpleDeltaNode next = new SimpleDeltaNode(this.getModel(), curPath, (IPath)(i == 0 ? oldFolderPath : null), curKind);
            if (bottom != null) {
                next.addChild(bottom);
            }
            bottom = next;
            ++i;
        }
        return bottom;
    }

    private Model getModel() {
        return ModelAccess.getModel((UniqueName)this.getModelUin());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SimpleDeltaNode
    implements ModelDeltaNode {
        private ModelDeltaNodeKind myKind;
        private LinkedList myChildren = new LinkedList();
        private UniqueName myUin;
        private UniqueName myOriginalUin;
        private Model myModel;

        private static UniqueName toUin(IPath path) {
            return path == null ? null : UniqueNameUtil.createResourceUin((IRootRelativePath)RootRelativePath.valueOf((IPath)path));
        }

        public SimpleDeltaNode(Model model, UniqueName uin, UniqueName originalUin, ModelDeltaNodeKind kind) {
            this.myModel = model;
            this.myKind = kind;
            this.myUin = uin;
            this.myOriginalUin = originalUin;
        }

        public SimpleDeltaNode(Model model, IPath path, IPath originalPath, ModelDeltaNodeKind kind) {
            this(model, SimpleDeltaNode.toUin(path), SimpleDeltaNode.toUin(originalPath), kind);
        }

        public void addChild(SimpleDeltaNode child) {
            this.myChildren.add(child);
        }

        public Enumeration changedChildren() {
            return Collections.enumeration(this.myChildren);
        }

        public Element getElement() {
            return this.myModel.findElement(this.myUin);
        }

        public UniqueName getElementUniqueName() {
            return this.myUin;
        }

        public UniqueName getOriginalElementUniqueName() {
            return this.myOriginalUin;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isChanged() {
            return this.myKind.isChanged();
        }

        public boolean isDeleted() {
            return this.myKind.isDeleted();
        }

        public boolean isNew() {
            return this.myKind.isNew();
        }

        public boolean isTotallyChanged() {
            return this.myKind.isTotallyChanged();
        }
    }
}

