/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom;

import com.tssap.selena.dom.nodeset.CachedDesignModelScope;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.dom.nodeset.NodeSetMover;
import com.tssap.selena.dom.nodeset.UndoTransparentShortCommand;
import com.tssap.selena.internal.dom.DeferredCommandManager;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.internal.dom.rename.pakkage.MultiReferenceFinder;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.ProjectRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.providers.resources.RootRelativePath;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.UndoTransparableCommand;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class JavaPackageSynchronizer {
    private DesignRootAccess myDesignRoot;
    private DeferredCommandManager myDeferredCommandManager;

    public JavaPackageSynchronizer(DesignRootAccess designRoot) {
        this.myDesignRoot = designRoot;
        this.myDeferredCommandManager = new DeferredCommandManager();
    }

    public void handleJavaPackageDeletion(IProjectRelativePath path) {
        IContainer designFolder;
        if (this.isSynchronizationNeeded(path) && (designFolder = this.getUnderDesignRoot(path)) != null && designFolder.exists()) {
            this.deleteFolderLater(designFolder);
        }
    }

    public void handleJavaPackageRenaming(IProjectRelativePath fromPath, IProjectRelativePath destPath, Map substitutionMap) {
        if (this.isSynchronizationNeeded(fromPath)) {
            IProjectRelativePath destPathUnderDesignRoot;
            IContainer designFrom = this.getUnderDesignRoot(fromPath);
            IContainer designDest = this.getUnderDesignRoot(destPath);
            if (!(designDest != null && designDest.exists() || (destPathUnderDesignRoot = this.getPathUnderDesignRoot(destPath)) == null)) {
                this.renameFolderUnderDesignRootLater(designFrom, destPathUnderDesignRoot, substitutionMap);
            }
        }
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)this.myDesignRoot.getProject());
        this.substituteAllReferencesLater(modelUin, substitutionMap);
    }

    protected void runDeferredCommands() {
        this.myDeferredCommandManager.runDeferredCommands();
    }

    private IContainer forceParentFolderCreated(IProjectRelativePath destPathUnderDesignRoot) {
        RootRelativePath rootRelativePath = RootRelativePath.valueOf((IPath)destPathUnderDesignRoot.removeFirstSegments(this.myDesignRoot.getRootPath().segmentCount()));
        Assert.isLegal((rootRelativePath.segmentCount() > 0 ? 1 : 0) != 0, (String)"default package should not be changed");
        return this.myDesignRoot.primCreateUnderDesignRoot(rootRelativePath.removeLastSegments(1));
    }

    private void renameFolderUnderDesignRootLater(final IContainer folder, final IProjectRelativePath destPathUnderDesignRoot, final Map substitutionMap) {
        UndoTransparableCommand innerCommand = new UndoTransparableCommand(){

            public void run() {
                if (folder != null && folder.isAccessible() && JavaPackageSynchronizer.this.myDesignRoot.getRootPath().isPrefixOf((IPath)destPathUnderDesignRoot)) {
                    IProject project = folder.getProject();
                    IContainer destFolder = JavaPackageSynchronizer.this.myDesignRoot.primCreateUnderDesignRoot(destPathUnderDesignRoot.removeFirstSegments(JavaPackageSynchronizer.this.myDesignRoot.getRootPath().segmentCount()));
                    if (destFolder != null && destFolder.exists()) {
                        JavaPackageSynchronizer.moveDesignFiles(folder, destFolder, substitutionMap);
                    }
                    if (JavaPackageSynchronizer.isFolderLeaf(folder)) {
                        try {
                            folder.delete(3, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException cantDelete) {
                            cantDelete.printStackTrace();
                        }
                    }
                }
            }
        };
        this.myDeferredCommandManager.addCommand((Runnable)innerCommand);
    }

    private void deleteFolderLater(final IContainer folder) {
        ModelAccess.runCommandLater((Runnable)new UndoTransparableCommand(){

            public void run() {
                if (folder != null && folder.isAccessible() && JavaPackageSynchronizer.isFolderLeaf(folder)) {
                    if (JavaPackageSynchronizer.isFolderLeaf(folder)) {
                        try {
                            folder.delete(3, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            System.err.println("Can't delete folder " + folder.getFullPath());
                            e.printStackTrace();
                        }
                    } else {
                        IResource[] members = null;
                        try {
                            members = folder.members();
                        }
                        catch (CoreException e) {
                            System.err.println("Can't access members for " + folder.getFullPath());
                            e.printStackTrace();
                            return;
                        }
                        NullProgressMonitor nullMonitor = new NullProgressMonitor();
                        int i = 0;
                        while (i < members.length) {
                            IResource next = members[i];
                            if (next.getType() == 1) {
                                try {
                                    next.delete(3, (IProgressMonitor)nullMonitor);
                                }
                                catch (CoreException e) {
                                    System.err.println("Can't delete file: " + next.getFullPath());
                                    e.printStackTrace();
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
        });
    }

    private void substituteAllReferencesLater(final UniqueName modelUin, final Map substitutionMap) {
        ModelAccess.runCommandLater((Runnable)((Object)new UndoTransparentShortCommand(){

            public void run() {
                NodeSetCache cache = NodeSetCache.getCache(modelUin);
                MultiReferenceFinder finder = new MultiReferenceFinder(substitutionMap, true);
                finder.findAndReplace(new CachedDesignModelScope(cache));
            }
        }));
    }

    private boolean isSynchronizationNeeded(IProjectRelativePath path) {
        if (this.myDesignRoot.getRootPath().isPrefixOf((IPath)path)) {
            return false;
        }
        IContainer designFolder = this.getUnderDesignRoot(path);
        return designFolder != null && designFolder.exists();
    }

    private static boolean isFolderLeaf(IContainer folder) {
        try {
            IResource[] members = folder.members();
            int i = 0;
            while (i < members.length) {
                if (members[i].getType() == 2) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void moveDesignFiles(IContainer sourceFolder, IContainer destFolder, Map substitutionMap) {
        NodeSetCache cache = NodeSetCache.getCache(ModelUinSupport.createModelUin((IResource)sourceFolder));
        new NodeSetMover(cache, sourceFolder, substitutionMap).moveNodeSets(destFolder);
    }

    private IContainer getUnderDesignRoot(IProjectRelativePath path) {
        IProjectRelativePath fullPathUnderDesignRoot = this.getPathUnderDesignRoot(path);
        return fullPathUnderDesignRoot == null ? null : this.getProject().getFolder((IPath)fullPathUnderDesignRoot);
    }

    private IProjectRelativePath getPathUnderDesignRoot(IProjectRelativePath path) {
        IRootRelativePath rootRelativePath = RootManagerAccess.getRootManager((IProject)this.getProject()).rootRelativePath(path);
        if (rootRelativePath == null) {
            return null;
        }
        return ProjectRelativePath.valueOf((IPath)this.myDesignRoot.getRootPath().append((IPath)rootRelativePath));
    }

    private IProject getProject() {
        return this.myDesignRoot.getProject();
    }
}

