/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom;

import com.tssap.selena.internal.dom.DesignPackageCopyPaster;
import com.tssap.selena.internal.dom.JavaPackageSynchronizer;
import com.tssap.selena.internal.dom.providers.ProjectDescriptionParser;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootCopyPaster;
import com.tssap.selena.model.providers.resources.IRootManager;
import com.tssap.selena.model.providers.resources.IRootProvider;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.ProjectRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DesignRootAccess
implements IRootProvider {
    private static final IPath DEFAULT_DESIGN_ROOT = new Path("Model Folder");
    private static HashMap ourInstanceMap;
    private IProject myProject;
    private DesignPackageCopyPaster myPackageContentsCopyPaster;
    private IPath myCustomDesignRootPath;
    private JavaPackageSynchronizer myJavaPackageSynchronizer;

    private DesignRootAccess(IProject project) {
        this.myProject = project;
        this.myPackageContentsCopyPaster = new DesignPackageCopyPaster(this);
        String designRootPathAsString = new ProjectDescriptionParser(this.myProject).getDesignRoot();
        this.myCustomDesignRootPath = designRootPathAsString == null ? null : new Path(designRootPathAsString);
        this.myJavaPackageSynchronizer = new JavaPackageSynchronizer(this);
    }

    public JavaPackageSynchronizer getJavaPackageSynchronizer() {
        return this.myJavaPackageSynchronizer;
    }

    public void registered(IProject project) {
        Assert.isLegal((boolean)project.getName().equals(this.myProject.getName()));
    }

    public void unregistered(IProject project) {
        Assert.isLegal((boolean)project.getName().equals(this.myProject.getName()));
    }

    public boolean rename(IProjectRelativePath fromPath, IProjectRelativePath destPath) {
        return false;
    }

    public boolean canRename(IProjectRelativePath fromPath, IProjectRelativePath destPath) {
        return true;
    }

    public static DesignRootAccess getInstance(IProject project) {
        DesignRootAccess result;
        if (ourInstanceMap == null) {
            ourInstanceMap = new HashMap();
        }
        if ((result = (DesignRootAccess)ourInstanceMap.get(project.getName())) == null) {
            result = new DesignRootAccess(project);
            ourInstanceMap.put(project.getName(), result);
        }
        return result;
    }

    public IPath getRootPath() {
        return this.myCustomDesignRootPath == null ? DEFAULT_DESIGN_ROOT : this.myCustomDesignRootPath;
    }

    public void setRootPath(IPath path) {
        if (new ProjectDescriptionParser(this.getProject()).setDesignRoot(path.toString())) {
            this.myCustomDesignRootPath = path;
        }
    }

    public IContainer getDesignRoot() {
        return DesignRootAccess.createFolderChain((IContainer)this.myProject, this.getRootPath());
    }

    public boolean isUnderDesignRoot(IPath path) {
        IPath rootPath = this.getRootPath();
        Assert.isLegal((rootPath != null ? 1 : 0) != 0);
        return rootPath.isPrefixOf(path);
    }

    public UniqueName findResourceElementUin(IContainer container) {
        IPath path = container.getProjectRelativePath();
        Assert.isLegal((boolean)this.isUnderDesignRoot(path));
        IRootManager rootManager = RootManagerAccess.getRootManager((IProject)this.myProject);
        IRootRelativePath rootRelativePath = rootManager.rootRelativePath((IProjectRelativePath)ProjectRelativePath.valueOf((IPath)path));
        if (rootRelativePath == null) {
            return null;
        }
        return rootManager.getUniqueName(rootRelativePath);
    }

    public IContainer createUnderDesignRoot(IPath rootRelativePath) {
        this.myJavaPackageSynchronizer.runDeferredCommands();
        return this.primCreateUnderDesignRoot(rootRelativePath);
    }

    protected IContainer primCreateUnderDesignRoot(IPath rootRelativePath) {
        IContainer designRoot = this.getDesignRoot();
        if (designRoot == null) {
            return null;
        }
        if (rootRelativePath.isEmpty()) {
            return designRoot;
        }
        IFolder result = designRoot.getFolder(rootRelativePath);
        return result != null && result.isAccessible() ? result : DesignRootAccess.createFolderChain(this.getDesignRoot(), rootRelativePath);
    }

    private static IContainer createFolderChain(IContainer chainRoot, IPath folderPath) {
        if (chainRoot == null || !chainRoot.exists() || !chainRoot.isAccessible()) {
            return null;
        }
        if (folderPath.isEmpty()) {
            return chainRoot;
        }
        String firstSegment = folderPath.segment(0);
        Assert.isLegal((firstSegment != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)new Path(firstSegment).append(folderPath.removeFirstSegments(1)).equals((Object)folderPath));
        IFolder nextFolder = chainRoot.getFolder((IPath)new Path(firstSegment));
        if (nextFolder == null) {
            System.err.println("Can not access subfolder: " + firstSegment + " in folder: " + chainRoot.getProjectRelativePath());
            return null;
        }
        if (!nextFolder.exists()) {
            try {
                nextFolder.create(true, true, null);
            }
            catch (CoreException creationFails) {
                System.out.println("Creation fails: subfolder: " + firstSegment + "in folder: " + chainRoot.getProjectRelativePath() + "\n" + (Object)((Object)creationFails));
                return null;
            }
        }
        return DesignRootAccess.createFolderChain((IContainer)nextFolder, folderPath.removeFirstSegments(1));
    }

    public String getID() {
        return "com.tssap.selena.design_root";
    }

    public boolean isValidFolder(IProjectRelativePath path) {
        return this.isUnderDesignRoot((IPath)path);
    }

    public IRootProvider.ConsistencyType shouldBeConsistent() {
        return IRootProvider.ConsistencyType.FULL;
    }

    protected IProject getProject() {
        return this.myProject;
    }

    public IRootCopyPaster getCopyPaster() {
        return this.myPackageContentsCopyPaster;
    }
}

