/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.internal.dom.copypaste.DesignClipboardManager;
import com.tssap.selena.internal.dom.copypaste.IDesignClipboardCopy;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootCopyPaster;
import com.tssap.selena.model.providers.resources.IRootManager;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class DesignPackageCopyPaster
implements IRootCopyPaster {
    private DesignRootAccess myDesignRootProvider;
    private IProject myProject;
    private UniqueName myModelUin;
    private HashMap myPath2Copies;
    private static final DesignNodeSet[] NO_NODESETS = new DesignNodeSet[0];

    public DesignPackageCopyPaster(DesignRootAccess designRootProvider) {
        this.myDesignRootProvider = designRootProvider;
        this.myProject = this.myDesignRootProvider.getProject();
        this.myModelUin = ModelUinSupport.createModelUin((String)this.myProject.getName());
        this.myPath2Copies = new HashMap();
    }

    public boolean canCopy(IProjectRelativePath fromPath) {
        return this.myDesignRootProvider.isUnderDesignRoot((IPath)fromPath);
    }

    public void copy(IProjectRelativePath fromPath) {
        DesignElement[] allTopLevelElements = this.allTopLevelElements(fromPath);
        HashSet<Entity> copies = new HashSet<Entity>(20);
        Iterator<DesignElement> topLevelElements = Arrays.asList(allTopLevelElements).iterator();
        while (topLevelElements.hasNext()) {
            Entity curCopy;
            DesignElement curDesignElement = topLevelElements.next();
            Entity curModelElement = this.getModel().findEntity(NameUtil.getUniqueName(curDesignElement));
            if (curModelElement == null || !curModelElement.canCopy() || (curCopy = curModelElement.copy()) == null) continue;
            copies.add(curCopy);
        }
        this.myPath2Copies.put(fromPath, copies);
    }

    public boolean canCut(IProjectRelativePath fromPath) {
        return this.myDesignRootProvider.isUnderDesignRoot((IPath)fromPath);
    }

    public void cut(IProjectRelativePath fromPath) {
        DesignElement[] allTopLevelElements = this.allTopLevelElements(fromPath);
        HashSet<Entity> copies = new HashSet<Entity>(20);
        LinkedList<DesignElement> defferredDesignNodesAndLinks = new LinkedList<DesignElement>();
        Iterator<DesignElement> topLevelElements = Arrays.asList(allTopLevelElements).iterator();
        while (topLevelElements.hasNext()) {
            DesignElement curDesignElement = topLevelElements.next();
            if (curDesignElement instanceof DesignView) {
                Entity curCut;
                Entity curModelElement = this.getModel().findEntity(NameUtil.getUniqueName(curDesignElement));
                if (curModelElement == null || !curModelElement.canCut() || (curCut = curModelElement.cut()) == null) continue;
                copies.add(curCut);
                continue;
            }
            defferredDesignNodesAndLinks.add(curDesignElement);
        }
        Iterator defferredNodesLinks = defferredDesignNodesAndLinks.iterator();
        while (defferredNodesLinks.hasNext()) {
            Entity curCut;
            DesignElement curDesignElement = (DesignElement)defferredNodesLinks.next();
            Entity curModelElement = this.getModel().findEntity(NameUtil.getUniqueName(curDesignElement));
            if (curModelElement == null || !curModelElement.canCut() || (curCut = curModelElement.cut()) == null) continue;
            copies.add(curCut);
        }
        this.myPath2Copies.put(fromPath, copies);
    }

    public boolean canPaste(IProjectRelativePath fromPath, IProjectRelativePath toPath) {
        return true;
    }

    public void pasteBase(final IProjectRelativePath fromPath, IProjectRelativePath toPath, final Map collectedSubstitutionMap) {
        final Entity parentPackage = this.getModelPackage(toPath);
        final DesignClipboardManager clipboardManager = DesignClipboardManager.getInstance(this.getModel());
        Assert.isLegal((parentPackage != null ? 1 : 0) != 0);
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                HashSet copiesSet = (HashSet)DesignPackageCopyPaster.this.myPath2Copies.get(fromPath);
                if (copiesSet != null) {
                    Map designSubstitutions = DesignPackageCopyPaster.this.pasteDesignNodesViews(clipboardManager, parentPackage, copiesSet);
                    collectedSubstitutionMap.putAll(designSubstitutions);
                }
            }
        });
    }

    public void pasteDerived(final IProjectRelativePath fromPath, IProjectRelativePath toPath, final Map collectedSubstitutionMap) {
        final Entity parentPackage = this.getModelPackage(toPath);
        final DesignClipboardManager clipboardManager = DesignClipboardManager.getInstance(this.getModel());
        Assert.isLegal((parentPackage != null ? 1 : 0) != 0);
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                HashSet copiesSet = (HashSet)DesignPackageCopyPaster.this.myPath2Copies.get(fromPath);
                if (copiesSet != null) {
                    DesignPackageCopyPaster.this.pasteDesignLinks(clipboardManager, parentPackage, copiesSet, collectedSubstitutionMap);
                }
            }
        });
    }

    public void pasteTertiary(final IProjectRelativePath fromPath, IProjectRelativePath toPath, final Map collectedSubstitutionMap) {
        final Entity parentPackage = this.getModelPackage(toPath);
        final DesignClipboardManager clipboardManager = DesignClipboardManager.getInstance(this.getModel());
        Assert.isLegal((parentPackage != null ? 1 : 0) != 0);
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                HashSet copiesSet = (HashSet)DesignPackageCopyPaster.this.myPath2Copies.get(fromPath);
                if (copiesSet != null) {
                    DesignPackageCopyPaster.this.pasteReferences(clipboardManager, parentPackage, copiesSet, collectedSubstitutionMap);
                }
            }
        });
    }

    private Map pasteDesignNodesViews(DesignClipboardManager clipboardManager, Entity parentPackage, Collection copiesSet) {
        HashMap<UniqueName, Entity> allSubstitutions = new HashMap<UniqueName, Entity>();
        Iterator copies = copiesSet.iterator();
        while (copies.hasNext()) {
            Entity nextCopy = (Entity)copies.next();
            IDesignClipboardCopy nextClipboardCopy = clipboardManager.getCopy(nextCopy.getUniqueName());
            if (nextClipboardCopy == null) {
                System.err.println("1st stage: can not find clipboardcopy for uin: " + nextCopy.getUniqueName());
                continue;
            }
            Entity basePasted = nextClipboardCopy.pasteBaseElements(parentPackage, allSubstitutions);
            if (basePasted == null) continue;
            allSubstitutions.put(nextCopy.getUniqueName(), basePasted);
        }
        return allSubstitutions;
    }

    private Map pasteDesignLinks(DesignClipboardManager clipboardManager, Entity parentPackage, Collection copiesSet, Map allSubstitutions) {
        Iterator copies = copiesSet.iterator();
        while (copies.hasNext()) {
            Entity nextCopy = (Entity)copies.next();
            IDesignClipboardCopy nextClipboardCopy = clipboardManager.getCopy(nextCopy.getUniqueName());
            if (nextClipboardCopy == null) {
                System.err.println("2nd stage: can not find clipboardcopy for uin: " + nextCopy.getUniqueName());
                continue;
            }
            nextClipboardCopy.pasteDerivedElements(parentPackage, allSubstitutions);
        }
        return allSubstitutions;
    }

    private void pasteReferences(DesignClipboardManager clipboardManager, Entity parentPackage, Collection copiesSet, Map allSubstitutions) {
        Iterator copies = copiesSet.iterator();
        while (copies.hasNext()) {
            Entity nextCopy = (Entity)copies.next();
            IDesignClipboardCopy nextClipboardCopy = clipboardManager.getCopy(nextCopy.getUniqueName());
            if (nextClipboardCopy == null) {
                System.err.println("3nd stage: can not find clipboardcopy for uin: " + nextCopy.getUniqueName());
                continue;
            }
            nextClipboardCopy.pasteTertiaryElements(parentPackage, allSubstitutions);
        }
    }

    public void disposeCopy(IProjectRelativePath path) {
        HashSet copiesSet = (HashSet)this.myPath2Copies.remove(path);
        if (copiesSet != null) {
            Iterator copies = copiesSet.iterator();
            while (copies.hasNext()) {
                ((Entity)copies.next()).delete();
            }
        }
    }

    private Entity getModelPackage(IProjectRelativePath projectRelativePath) {
        UniqueName uin;
        IRootManager rootManager = RootManagerAccess.getRootManager((IProject)this.myProject);
        IRootRelativePath rootRelativePath = rootManager.rootRelativePath(projectRelativePath);
        if (rootRelativePath != null && (uin = rootManager.getUniqueName(rootRelativePath)) != null) {
            return this.getModel().findEntity(uin);
        }
        return null;
    }

    private DesignElement[] allTopLevelElements(IProjectRelativePath fromPath) {
        DesignNodeSet[] allNodeSets = this.getNodeSets(fromPath);
        LinkedList result = new LinkedList();
        Iterator<DesignNodeSet> nodeSets = Arrays.asList(allNodeSets).iterator();
        while (nodeSets.hasNext()) {
            DesignNodeSet next = nodeSets.next();
            Iterator members = next.iterator();
            while (members.hasNext()) {
                result.add(members.next());
            }
        }
        return result.toArray(new DesignElement[result.size()]);
    }

    private DesignNodeSet[] getNodeSets(IProjectRelativePath path) {
        IFolder folder = this.myProject.getFolder((IPath)path);
        if (folder == null || !folder.exists()) {
            return NO_NODESETS;
        }
        return this.getCache().nodeSets((IContainer)folder);
    }

    protected NodeSetCache getCache() {
        return NodeSetCache.getCache(this.myModelUin);
    }

    protected Model getModel() {
        return ModelAccess.getModel((UniqueName)this.myModelUin);
    }
}

