/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom;

import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.util.UndoTransparableCommand;
import com.tssap.selena.model.util.various.CancelableCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DeferredCommandManager {
    private List myCommandsList = null;

    public void addCommand(Runnable innerCommand) {
        if (this.myCommandsList == null) {
            this.myCommandsList = new LinkedList();
            this.myCommandsList.add(innerCommand);
            UndoTransparentCancelableCommand cancelableCommand = new UndoTransparentCancelableCommand(this.createDeferredCommand(), this.createFinishedCallback());
            ModelAccess.runCommandLater((Runnable)((Object)cancelableCommand));
        } else {
            this.myCommandsList.add(innerCommand);
        }
    }

    public void runDeferredCommands() {
        if (this.myCommandsList != null) {
            final Runnable[] commands = this.myCommandsList.toArray(new Runnable[this.myCommandsList.size()]);
            this.myCommandsList = null;
            ModelAccess.runCommand((Runnable)new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < commands.length) {
                        commands[i].run();
                        ++i;
                    }
                }
            });
        }
    }

    private Runnable createDeferredCommand() {
        return new Runnable(){

            public void run() {
                if (DeferredCommandManager.this.myCommandsList != null) {
                    Iterator commands = DeferredCommandManager.this.myCommandsList.iterator();
                    while (commands.hasNext()) {
                        ((Runnable)commands.next()).run();
                    }
                }
            }
        };
    }

    private Runnable createFinishedCallback() {
        return new Runnable(){

            public void run() {
                DeferredCommandManager.this.myCommandsList = null;
            }
        };
    }

    private class UndoTransparentCancelableCommand
    extends CancelableCommand
    implements UndoTransparableCommand {
        public UndoTransparentCancelableCommand(Runnable command, Runnable callBack) {
            super(command, callBack);
        }
    }
}

