/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.dom;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.internal.dom.DynamicDeltaNode;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import java.util.Enumeration;

public abstract class AbstractDeltaNode
implements DynamicDeltaNode {
    private Model myModel;
    private DesignElement myElement;
    private DynamicDeltaNode myParent;

    public AbstractDeltaNode(DynamicDeltaNode parentDeltaNode, Model model, DesignElement element) {
        this.myParent = parentDeltaNode;
        this.myElement = element;
        this.myModel = model;
    }

    public abstract void registerChanged();

    public final Element getElement() {
        return this.getModel().findEntity(this.getElementUniqueName());
    }

    public final UniqueName getElementUniqueName() {
        return NameUtil.getUniqueName(this.myElement);
    }

    public UniqueName getOriginalElementUniqueName() {
        return this.getElementUniqueName();
    }

    public final boolean isEntity() {
        return !this.isReferenceCollection();
    }

    public final boolean isLink() {
        return this.myElement instanceof DesignLink;
    }

    public final boolean isNode() {
        return this.myElement instanceof DesignNode;
    }

    public final boolean isReferenceCollection() {
        return this.myElement instanceof DesignView;
    }

    protected Model getModel() {
        return this.myModel;
    }

    protected DesignElement getReferent() {
        return this.myElement;
    }

    public DynamicDeltaNode getParent() {
        return this.myParent;
    }

    void setParent(DynamicDeltaNode parent) {
        if (this.myParent != null) {
            throw new RuntimeException("Changing parents is not implemented");
        }
        this.myParent = parent;
    }

    public abstract void removeChildDelta(ModelDeltaNode var1);

    public abstract void addChildDelta(ModelDeltaNode var1);

    public abstract Enumeration changedChildren();

    public abstract boolean isTotallyChanged();

    public abstract boolean isChanged();

    public abstract boolean isDeleted();

    public abstract boolean isNew();

    public abstract boolean isEmpty();
}

