/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.search;

import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignParticipant;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IDesignVisitor;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.search.IDesignMatcher;
import com.tssap.selena.dom.search.IDesignSearchScope;
import java.util.HashSet;
import java.util.Set;

public class AbstractDesignFinder
implements IDesignVisitor {
    private IDesignMatcher myMatcher;
    private HashSet myCollectedResults;

    public AbstractDesignFinder(IDesignMatcher matcher) {
        this.myMatcher = matcher;
        this.myCollectedResults = new HashSet();
    }

    protected final void performFind(IDesignSearchScope scope) {
        this.myCollectedResults.clear();
        DesignNodeSet[] nodesets = scope.getNodeSets();
        if (nodesets == null || nodesets.length == 0) {
            return;
        }
        try {
            int i = 0;
            while (i < nodesets.length) {
                DesignNodeSet cur = nodesets[i];
                cur.accept(this);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.myCollectedResults.clear();
        }
    }

    protected Set getCollectedResults() {
        return this.myCollectedResults;
    }

    public boolean visitLink(DesignLink link) throws Exception {
        Object possibleResult = this.myMatcher.matchLink(link);
        if (possibleResult != null) {
            this.myCollectedResults.add(possibleResult);
        }
        return true;
    }

    public boolean visitNode(DesignNode node) throws Exception {
        Object possibleResult = this.myMatcher.matchNode(node);
        if (possibleResult != null) {
            this.myCollectedResults.add(possibleResult);
        }
        return true;
    }

    public boolean visitView(DesignView view) throws Exception {
        Object possibleResult = this.myMatcher.matchView(view);
        if (possibleResult != null) {
            this.myCollectedResults.add(possibleResult);
        }
        return true;
    }

    public boolean visitParticipant(DesignParticipant participant) throws Exception {
        Object possibleResult = this.myMatcher.matchParticipant(participant);
        if (possibleResult != null) {
            this.myCollectedResults.add(possibleResult);
        }
        return true;
    }

    public boolean visitReference(DesignReference reference) throws Exception {
        Object possibleResult = this.myMatcher.matchReference(reference);
        if (possibleResult != null) {
            this.myCollectedResults.add(possibleResult);
        }
        return true;
    }

    public boolean visitNodeSet(DesignNodeSet nodeSet) throws Exception {
        Object possibleResult = this.myMatcher.matchNodeSet(nodeSet);
        if (possibleResult != null) {
            this.myCollectedResults.add(possibleResult);
        }
        return true;
    }
}

