/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.property;

import com.tssap.selena.dom.property.IDesignPropertySetDescriptor;
import com.tssap.selena.dom.property.IDesignPropertySetValidator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class NotValidatableDescriptor
implements IDesignPropertySetDescriptor,
IExecutableExtension {
    public static final String ATTR_MUTABLE = "mutable";
    public static final String ATTR_MULTIVALUED = "multivalued";
    public static final String ATTR_METACLASS = "metaclass";
    public static final String ATTR_PROPERTY_NAME = "propertyName";
    public static final String ALL_METACLASSES = "*";
    public static final String DELIMITERS = ",";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ALL_UML_DIAGRAMS = "*UML_DIAGRAMS";
    private static final String[] UML_DIAGRAM_METACLASSES = new String[]{"Activity Diagram", "Collaboration Diagram", "Deployment Diagram", "Component Diagram", "State Diagram", "Sequence Diagram", "Use Case Diagram", "Class Diagram", "Package Diagram"};
    private boolean myMutable;
    private boolean myMultivalued;
    private String myName;
    private Collection myApplicableMetaclasses;
    private boolean myApplicableToAll;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.checkAssertion("propertyName attribute is required", config.getAttribute(ATTR_PROPERTY_NAME) != null);
        this.myName = config.getAttribute(ATTR_PROPERTY_NAME);
        String metaclasses = config.getAttribute(ATTR_METACLASS);
        if (metaclasses == null || ALL_METACLASSES.equals(metaclasses)) {
            this.myApplicableToAll = true;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(metaclasses, DELIMITERS);
            this.checkAssertion("No metaclasses specified :" + metaclasses, tokenizer.hasMoreTokens());
            while (tokenizer.hasMoreTokens()) {
                String nextToken;
                if (this.myApplicableMetaclasses == null) {
                    this.myApplicableMetaclasses = new HashSet();
                }
                if (ALL_UML_DIAGRAMS.equals(nextToken = tokenizer.nextToken())) {
                    this.myApplicableMetaclasses.addAll(Arrays.asList(UML_DIAGRAM_METACLASSES));
                    continue;
                }
                this.myApplicableMetaclasses.add(nextToken);
            }
        }
        this.myMultivalued = TRUE.equals(config.getAttribute(ATTR_MULTIVALUED));
        this.myMutable = !FALSE.equals(config.getAttribute(ATTR_MUTABLE));
    }

    private void checkAssertion(String message, boolean tested) throws CoreException {
        if (!tested) {
            throw new CoreException((IStatus)new Status(4, "com.tssap.selena.dom", 0, message, null));
        }
    }

    public boolean isMutable() {
        return this.myMutable;
    }

    public boolean isMultivalued() {
        return this.myMultivalued;
    }

    public boolean isApplicable(String metaclass) {
        return this.myApplicableToAll || this.myApplicableMetaclasses != null && this.myApplicableMetaclasses.contains(metaclass);
    }

    public String getPropertyName() {
        return this.myName;
    }

    public IDesignPropertySetValidator getValidator() {
        return null;
    }
}

