/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.options;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.util.Assert;

public abstract class StringToBoolMap {
    private String[] keys;
    private boolean[] values;
    private Map keysToIndexesMap = new HashMap();
    private static final String SEPARATOR_STR = ",";

    public StringToBoolMap() {
        this.keys = this.getAllKeys();
        Assert.isNotNull((Object)this.keys);
        this.values = new boolean[this.keys.length];
        this.setAllValues(false);
        int i = 0;
        while (i < this.keys.length) {
            this.keysToIndexesMap.put(this.keys[i], new Integer(i));
            ++i;
        }
    }

    protected abstract String[] getAllKeys();

    public String[] getKeysWithValue(boolean value) {
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        while (i < this.values.length) {
            if (this.values[i] == value) {
                list.add(this.keys[i]);
            }
            ++i;
        }
        String[] array = new String[list.size()];
        return list.toArray(array);
    }

    public void setKeysWithValue(Object[] selKeys, boolean value) {
        HashSet<Object> keySet = new HashSet<Object>(Arrays.asList(selKeys));
        int i = 0;
        while (i < this.keys.length) {
            this.values[i] = keySet.contains(this.keys[i]) ? value : !value;
            ++i;
        }
    }

    public void setAllValues(boolean value) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = value;
            ++i;
        }
    }

    public boolean getValue(String key) {
        Integer pos = (Integer)this.keysToIndexesMap.get(key);
        if (pos == null) {
            return false;
        }
        return this.values[pos];
    }

    public void setValue(String key, boolean value) {
        Integer pos = (Integer)this.keysToIndexesMap.get(key);
        Assert.isNotNull((Object)pos);
        this.values[pos.intValue()] = value;
    }

    public String toString() {
        String[] selected = this.getKeysWithValue(true);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < selected.length) {
            buf.append(selected[i]);
            if (i < selected.length - 1) {
                buf.append(SEPARATOR_STR);
            }
            ++i;
        }
        return buf.toString();
    }

    public void fromString(String str) {
        if (str == null || str.equals("")) {
            return;
        }
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(str, SEPARATOR_STR);
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        String[] array = new String[list.size()];
        this.setKeysWithValue(list.toArray(array), true);
    }
}

