/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.options;

import com.tssap.selena.dom.options.Messages;
import com.tssap.selena.dom.options.NodeSetOptionSupport;
import com.tssap.selena.dom.options.StringToBoolMap;
import com.tssap.selena.ui.prefpages.PreferenceTabPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;

public class StoreSeparatelyPreferencePage
extends PreferenceTabPage {
    private CheckboxTableViewer tableViewer = null;
    private Combo presetCombo = null;
    private static final int PRESET_NO_SEPARATION = 0;
    private static final int PRESET_SEPARATE_ALL = 1;
    private static final int PRESET_SEPARATE_CUSTOM = 2;
    private static final String[] PRESET_STRINGS = new String[]{Messages.getString("StoreSeparatelyPreferencePage.presets.no_separation"), Messages.getString("StoreSeparatelyPreferencePage.presets.separate_all"), Messages.getString("StoreSeparatelyPreferencePage.presets.separate_selected")};

    public StoreSeparatelyPreferencePage() {
        this.setDescription(Messages.getString("StoreSeparatelyPreferencePage.description"));
    }

    private Composite createGroup(Composite parent, int style, String title) {
        Group group = new Group(parent, 0);
        group.setText(title);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(style));
        Composite spacingComposite = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout();
        spacingComposite.setLayout((Layout)layout);
        spacingComposite.setLayoutData((Object)new GridData(768));
        return spacingComposite;
    }

    public Control createContents(Composite parent) {
        Composite pane = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        pane.setLayout((Layout)layout);
        pane.setLayoutData((Object)new GridData(1808));
        Composite presets = this.createGroup(pane, 768, Messages.getString("StoreSeparatelyPreferencePage.presets.group_name"));
        this.presetCombo = new Combo(presets, 12);
        this.presetCombo.setLayoutData((Object)new GridData(768));
        int i = 0;
        while (i < PRESET_STRINGS.length) {
            this.presetCombo.add(PRESET_STRINGS[i]);
            ++i;
        }
        this.presetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StoreSeparatelyPreferencePage.this.presetItemSelected(StoreSeparatelyPreferencePage.this.presetCombo.getSelectionIndex());
            }
        });
        Composite types = this.createGroup(pane, 1808, Messages.getString("StoreSeparatelyPreferencePage.metaclasses.group_name"));
        this.tableViewer = CheckboxTableViewer.newCheckList((Composite)types, (int)2562);
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(14);
        this.tableViewer.getTable().setLayoutData((Object)data);
        final StringToBoolMap map = NodeSetOptionSupport.getInstance().getMetaclassesToBoolMap();
        this.tableViewer.add((Object[])map.getAllKeys());
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                map.setKeysWithValue(StoreSeparatelyPreferencePage.this.tableViewer.getCheckedElements(), true);
                StoreSeparatelyPreferencePage.this.presetCombo.select(StoreSeparatelyPreferencePage.this.getPresetItem(map));
            }
        });
        this.tableViewer.setCheckedElements((Object[])map.getKeysWithValue(true));
        this.presetCombo.select(this.getPresetItem(map));
        this.presetItemSelected(this.getPresetItem(map));
        return pane;
    }

    private void presetItemSelected(int i) {
        StringToBoolMap map = NodeSetOptionSupport.getInstance().getMetaclassesToBoolMap();
        if (i == 0) {
            map.setAllValues(false);
            this.setTableViewerEnabled(false);
        } else if (i == 1) {
            map.setAllValues(true);
            this.setTableViewerEnabled(false);
        } else {
            this.setTableViewerEnabled(true);
        }
        this.tableViewer.setCheckedElements((Object[])map.getKeysWithValue(true));
    }

    private void setTableViewerEnabled(boolean b) {
        Table table = this.tableViewer.getTable();
        table.setEnabled(b);
        table.getVerticalBar().setVisible(b);
        if (b) {
            table.setBackground(Display.getCurrent().getSystemColor(25));
        } else {
            table.setBackground(Display.getCurrent().getSystemColor(22));
        }
    }

    private int getPresetItem(StringToBoolMap map) {
        String[] selected = map.getKeysWithValue(true);
        if (selected.length == 0) {
            return 0;
        }
        String[] unselected = map.getKeysWithValue(false);
        if (unselected.length == 0) {
            return 1;
        }
        return 2;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return NodeSetOptionSupport.getInstance().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        StringToBoolMap map = NodeSetOptionSupport.getInstance().getMetaclassesToBoolMap();
        this.getPreferenceStore().setValue("Separated.Metaclasses", map.toString());
        return super.performOk();
    }

    public void performDefaults() {
        super.performDefaults();
        this.presetCombo.select(0);
        this.presetItemSelected(0);
    }
}

