/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.options;

import com.tssap.selena.dom.options.StringToBoolMap;
import com.tssap.selena.internal.dom.DOMPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class NodeSetOptionSupport {
    public static final String PS_SEPARATE_METACLASSES = "Separated.Metaclasses";
    private static final String[] METACLASSES = new String[]{"Activation", "Activity", "Actor", "Component", "Decision", "End State", "Entity EJB", "Message Link", "Note", "Object", "Message Link", "Session EJB", "Start State", "State", "Subsystem", "Swimlane", "System Boundary", "Transition", "Use Case"};
    private static NodeSetOptionSupport ourInstance;
    private StringToBoolMap metaclassesToBoolMap = new StringToBoolMap(){

        protected String[] getAllKeys() {
            return METACLASSES;
        }
    };

    private NodeSetOptionSupport() {
        String selected = this.getPreferenceStore().getString(PS_SEPARATE_METACLASSES);
        this.metaclassesToBoolMap.fromString(selected);
    }

    public static NodeSetOptionSupport getInstance() {
        if (ourInstance == null) {
            ourInstance = new NodeSetOptionSupport();
        }
        return ourInstance;
    }

    public boolean isStoreSeparately(String metaclass) {
        return this.metaclassesToBoolMap.getValue(metaclass);
    }

    public IPreferenceStore getPreferenceStore() {
        return DOMPlugin.getDefault().getPreferenceStore();
    }

    public StringToBoolMap getMetaclassesToBoolMap() {
        return this.metaclassesToBoolMap;
    }
}

