/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.nodeset;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.dom.nodeset.UndoTransparentShortCommand;
import com.tssap.selena.dom.search.IDesignSearchScope;
import com.tssap.selena.internal.dom.MovedDiagramDeltaProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.internal.dom.rename.pakkage.MultiReferenceFinder;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.resources.IProjectRelativePath;
import com.tssap.selena.model.providers.resources.IRootRelativePath;
import com.tssap.selena.model.providers.resources.ProjectRelativePath;
import com.tssap.selena.model.providers.resources.RootManagerAccess;
import com.tssap.selena.model.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class NodeSetMover {
    private final NodeSetCache myCache;
    private final Map mySubstitutionMap;
    private DesignNodeSet[] myNodeSets;
    private IRootRelativePath mySourceFolderPath;

    public NodeSetMover(NodeSetCache cache, IContainer sourceFolder, Map substitutionMap) {
        this.myCache = cache;
        this.mySubstitutionMap = substitutionMap == null ? Collections.EMPTY_MAP : substitutionMap;
        this.myNodeSets = this.myCache.nodeSets(sourceFolder);
        this.mySourceFolderPath = NodeSetMover.extractRootRelativePath(sourceFolder);
    }

    public void moveNodeSets(final IContainer destFolder) {
        Assert.isLegal((destFolder != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)destFolder.exists());
        Assert.isLegal((this.myNodeSets != null ? 1 : 0) != 0);
        final IRootRelativePath destFolderPath = NodeSetMover.extractRootRelativePath(destFolder);
        Assert.isLegal((destFolderPath != null ? 1 : 0) != 0);
        ModelAccess.runCommand((Runnable)((Object)new UndoTransparentShortCommand(){

            public void run() {
                int i = 0;
                while (i < NodeSetMover.this.myNodeSets.length) {
                    DesignNodeSet next = NodeSetMover.this.myNodeSets[i];
                    if (NodeSetMover.isDefaultDiagramNodeSet(next)) {
                        NodeSetMover.this.moveDefaultDiagramNodeSet(next, destFolderPath, destFolder);
                    } else {
                        NodeSetMover.this.move(next, destFolder);
                    }
                    ++i;
                }
            }
        }));
    }

    private void move(final DesignNodeSet nodeSet, final IContainer destFolder) {
        Assert.isLegal((destFolder != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)destFolder.exists());
        nodeSet.runCommand(new Runnable(){

            public void run() {
                IFile curFile = nodeSet.getFile();
                IFile destFile = destFolder.getFile((IPath)new Path(curFile.getFullPath().lastSegment()));
                if (curFile.getFullPath().equals((Object)destFile.getFullPath())) {
                    return;
                }
                if (destFile == null || destFile.exists()) {
                    System.err.println("Can not move design file:" + curFile.getFullPath() + " to folder: " + destFolder.getFullPath());
                    return;
                }
                NodeSetMover.this.myCache.dropNodeSet(curFile);
                nodeSet.internalSetFile(destFile);
                NodeSetMover.this.substitute(nodeSet);
                NodeSetMover.this.myCache.internalAddNodeSet(destFile, nodeSet);
                NodeSetMover.this.myCache.setFileChangesAlreadyProcessed(curFile, true);
                NodeSetMover.this.myCache.setFileChangesAlreadyProcessed(destFile, true);
                try {
                    curFile.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException cantDelete) {
                    cantDelete.printStackTrace();
                }
            }
        });
        nodeSet.internallyChanged(false);
    }

    private DesignNodeSet getDefaultDiagramNodeSet(DesignNodeSet oldNodeSet, IContainer destFolder) {
        DesignNodeSet[] nodeSets = this.myCache.nodeSets(destFolder);
        int i = 0;
        while (i < nodeSets.length) {
            DesignNodeSet next = nodeSets[i];
            if (NodeSetMover.isDefaultDiagramNodeSet(next)) {
                return next;
            }
            ++i;
        }
        IFile newFile = destFolder.getFile((IPath)new Path(oldNodeSet.getFile().getFullPath().lastSegment()));
        DesignNodeSet result = new DesignNodeSet(newFile, null);
        this.myCache.internalAddNodeSet(newFile, result);
        return result;
    }

    private DesignView forceCreateDefaultDiagram(DesignNodeSet defaultDiagramNodeSet) {
        Iterator members = defaultDiagramNodeSet.iterator();
        while (members.hasNext()) {
            DesignElement next = (DesignElement)members.next();
            if (!NodeSetMover.isDefaultDiagram(next)) continue;
            return (DesignView)next;
        }
        return NodeSetMover.createPackageDiagram(defaultDiagramNodeSet);
    }

    private static DesignView createPackageDiagram(final DesignNodeSet nodeSet) {
        String shapeType = "Package Diagram";
        boolean isDefault = true;
        final String newDesignId = "V" + NameUtil.newDesignId("Package Diagram");
        final DesignView[] createdView = new DesignView[1];
        nodeSet.runCommand(new Runnable(){

            public void run() {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("$metaclass", "Package Diagram");
                properties.put("$defaultDiagram", "true");
                createdView[0] = nodeSet.createChildView(newDesignId, properties, false);
                nodeSet.internallyChanged(false);
            }
        });
        return createdView[0];
    }

    private void moveDefaultDiagramNodeSet(final DesignNodeSet defaultDiagramNodeSet, final IRootRelativePath destFolderPath, IContainer destFolder) {
        Assert.isLegal((destFolder != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)destFolder.exists());
        final DesignNodeSet destNodeSet = this.getDefaultDiagramNodeSet(defaultDiagramNodeSet, destFolder);
        Assert.isLegal((destNodeSet != null ? 1 : 0) != 0);
        Assert.isLegal((defaultDiagramNodeSet != null ? 1 : 0) != 0);
        this.myCache.setFileChangesAlreadyProcessed(defaultDiagramNodeSet.getFile(), true);
        this.myCache.setFileChangesAlreadyProcessed(destNodeSet.getFile(), true);
        NodeSetMover.runMultiNodeSetsCommand(defaultDiagramNodeSet, destNodeSet, new Runnable(){

            public void run() {
                DesignView oldDefaultDiagram = null;
                LinkedList<DesignElement> notDefaultMembers = new LinkedList<DesignElement>();
                Iterator members = defaultDiagramNodeSet.iterator();
                while (members.hasNext()) {
                    DesignElement next = (DesignElement)members.next();
                    if (NodeSetMover.isDefaultDiagram(next)) {
                        oldDefaultDiagram = (DesignView)next;
                        continue;
                    }
                    notDefaultMembers.add(next);
                }
                Iterator cachedNotDefaultMembers = notDefaultMembers.iterator();
                while (cachedNotDefaultMembers.hasNext()) {
                    DesignElement next = (DesignElement)cachedNotDefaultMembers.next();
                    defaultDiagramNodeSet.internalRemoveMember(next);
                    next.internalChangeNodeSet(destNodeSet);
                    destNodeSet.internalAddMember(next);
                }
                Assert.isLegal((oldDefaultDiagram != null ? 1 : 0) != 0, (String)("NodeSet: " + defaultDiagramNodeSet.getFile().getFullPath() + " does not contain default diagram"));
                DesignView destDiagram = NodeSetMover.this.forceCreateDefaultDiagram(destNodeSet);
                if (destDiagram != null) {
                    UniqueName oldDiagramUin = NameUtil.getUniqueName(oldDefaultDiagram);
                    UniqueName newDiagramUin = NameUtil.getUniqueName(destDiagram);
                    MovedDiagramDeltaProvider.diagramMoved(NodeSetMover.this.getModel(), NodeSetMover.this.mySourceFolderPath, oldDiagramUin, destFolderPath, newDiagramUin, true);
                }
                DesignReference[] oldReferences = oldDefaultDiagram.getReferences();
                int i = 0;
                while (i < oldReferences.length) {
                    DesignReference nextOldReference = oldReferences[i];
                    if (DesignNotion.hasDesignProperty(nextOldReference, "$shortcutReference")) {
                        DesignReference newReference = destDiagram.internalAddReference(nextOldReference.getProxyId());
                        NodeSetMover.copyProperties(nextOldReference, newReference);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < oldReferences.length) {
                    DesignReference nextOldReference = oldReferences[i2];
                    if (DesignNotion.hasDesignProperty(nextOldReference, "$shortcutReference")) {
                        nextOldReference.delete();
                    }
                    ++i2;
                }
                Iterator newMembers = destNodeSet.iterator();
                while (newMembers.hasNext()) {
                    DesignElement next = (DesignElement)newMembers.next();
                    NodeSetMover.this.myCache.getTreeDeltaBuilder().registerChanged(next);
                }
            }
        });
        defaultDiagramNodeSet.internallyChanged(false);
        destNodeSet.internallyChanged(false);
    }

    private void substitute(final DesignNodeSet nodeSet) {
        if (this.mySubstitutionMap.isEmpty()) {
            return;
        }
        final IDesignSearchScope scope = new IDesignSearchScope(){

            public DesignNodeSet[] getNodeSets() {
                return new DesignNodeSet[]{nodeSet};
            }
        };
        nodeSet.runCommand(new Runnable(){

            public void run() {
                new MultiReferenceFinder(NodeSetMover.this.mySubstitutionMap, false).findAndReplace(scope);
                Iterator members = nodeSet.iterator();
                while (members.hasNext()) {
                    DesignElement next = (DesignElement)members.next();
                    NodeSetMover.this.myCache.getTreeDeltaBuilder().registerChanged(next);
                }
            }
        });
    }

    private Model getModel() {
        return ModelAccess.getModel((UniqueName)this.myCache.getModelUin());
    }

    private static IRootRelativePath extractRootRelativePath(IContainer container) {
        Assert.isLegal((container != null && container.exists() ? 1 : 0) != 0);
        return RootManagerAccess.getRootManager((IProject)container.getProject()).rootRelativePath((IProjectRelativePath)ProjectRelativePath.valueOf((IPath)container.getProjectRelativePath()));
    }

    private static boolean isDefaultDiagramNodeSet(DesignNodeSet nodeSet) {
        Iterator members = nodeSet.iterator();
        while (members.hasNext()) {
            DesignElement next = (DesignElement)members.next();
            if (!NodeSetMover.isDefaultDiagram(next)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefaultDiagram(DesignElement designElement) {
        return designElement instanceof DesignView && DesignNotion.hasDesignProperty(designElement, "$defaultDiagram");
    }

    private static void copyProperties(DesignNotion original, DesignNotion dest) {
        DesignProperty[] originalProperties = original.getProperties();
        int i = 0;
        while (i < originalProperties.length) {
            DesignProperty next = originalProperties[i];
            if (next.getName() != null && next.getValue() != null) {
                dest.createProperty(next.getName(), next.getValue());
            }
            ++i;
        }
    }

    private static void runMultiNodeSetsCommand(DesignNodeSet first, final DesignNodeSet second, final Runnable command) {
        first.runCommand(new Runnable(){

            public void run() {
                second.runCommand(command);
            }
        });
    }
}

