/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.nodeset;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.nodeset.CachedDesignModelScope;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.dom.search.DesignLinkFinder;
import com.tssap.selena.dom.search.IncomingLinkMatcher;
import com.tssap.selena.dom.search.SameDirectorySearchScope;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.UniqueName;

public class NodeSetIndex {
    private static DesignLink[] NO_LINKS = new DesignLink[0];
    private NodeSetCache myCache;
    private boolean myAllModelLoaded;
    private static final String NOT_USED_ID_PREFIX = "N1g5r6d67twdzslxj76";

    public NodeSetIndex(NodeSetCache cache) {
        this.myCache = cache;
    }

    public void loadAllModel(boolean force) {
        if (!this.myAllModelLoaded || force) {
            int i = 0;
            while (this.myCache.findElement(NOT_USED_ID_PREFIX + i) != null) {
                ++i;
            }
            this.myAllModelLoaded = true;
        }
    }

    public DesignLink[] findIncomingLink(UniqueName targetUin) {
        CachedDesignModelScope scope = new CachedDesignModelScope(this.myCache);
        IncomingLinkMatcher matcher = new IncomingLinkMatcher(targetUin);
        return new DesignLinkFinder(matcher).doFind(scope);
    }

    public DesignLink[] findIncomingLink(DesignElement target) {
        if (target instanceof DesignLink) {
            return NO_LINKS;
        }
        SameDirectorySearchScope scope = new SameDirectorySearchScope(this.myCache, target);
        IncomingLinkMatcher matcher = new IncomingLinkMatcher(NameUtil.getUniqueName(target));
        return new DesignLinkFinder(matcher).doFind(scope);
    }
}

