/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.nodeset;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.nodeset.DefaultNamingStrategy;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.IDesignFileNamingStrategy;
import com.tssap.selena.dom.nodeset.NodeSetFileFinder;
import com.tssap.selena.dom.nodeset.NodeSetIndex;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.internal.dom.IDesignReferenceChangeListener;
import com.tssap.selena.internal.dom.TreeDeltaBuilder;
import com.tssap.selena.internal.dom.io.NonCrypticDesignParser;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class NodeSetCache {
    private NonCrypticDesignParser myDesignParser;
    private IDesignReferenceChangeListener myReferenceListener;
    private static HashMap ourInstances = new HashMap();
    private final UniqueName myModelUin;
    private TreeDeltaBuilder myTreeDeltaBuilder;
    private IDesignFileNamingStrategy myNamingStrategy;
    private NodeSetFileFinder myFileFinder;
    private HashMap myPath2NodeSet = new HashMap();
    private HashSet myNotParsablePaths = new HashSet();
    private NodeSetIndex myIndexer;
    private HashSet myAlreadyProcessedPathes = new HashSet();
    private static HashMap ourWithoutFileNodeSetsMaps = new HashMap();

    private NodeSetCache(UniqueName modelUin) {
        this.myModelUin = modelUin;
        this.myNamingStrategy = new DefaultNamingStrategy(this);
        this.myIndexer = new NodeSetIndex(this);
    }

    public UniqueName getModelUin() {
        return this.myModelUin;
    }

    public boolean isFileChangesAlreadyProcessed(IFile file) {
        return this.myAlreadyProcessedPathes.contains(file.getProjectRelativePath());
    }

    public void setFileChangesAlreadyProcessed(IFile file, boolean alreadyProcessed) {
        if (alreadyProcessed) {
            this.myAlreadyProcessedPathes.add(file.getProjectRelativePath());
        } else {
            this.myAlreadyProcessedPathes.remove(file.getProjectRelativePath());
        }
    }

    public static NodeSetCache getCache(UniqueName modelUin) {
        NodeSetCache result = (NodeSetCache)ourInstances.get(modelUin);
        if (result == null) {
            result = new NodeSetCache(modelUin);
            ourInstances.put(modelUin, result);
        }
        return result;
    }

    public DesignNodeSet[] nodeSets(IContainer container) {
        LinkedList<DesignNodeSet> result = new LinkedList<DesignNodeSet>();
        IResource[] members = null;
        try {
            members = container.members();
        }
        catch (CoreException canNotAccessMembers) {
            canNotAccessMembers.printStackTrace();
        }
        if (members != null) {
            int i = 0;
            while (i < members.length) {
                DesignNodeSet curNodeSet;
                IResource curResource = members[i];
                if (this.getNamingStrategy().isNodeSetFile(curResource) && (curNodeSet = this.parse((IFile)curResource)) != null) {
                    result.add(curNodeSet);
                }
                ++i;
            }
        }
        DesignNodeSet[] withoutFileChildren = this.findWithoutFileChildren(container);
        int i = 0;
        while (i < withoutFileChildren.length) {
            result.add(withoutFileChildren[i]);
            ++i;
        }
        return result.toArray(new DesignNodeSet[result.size()]);
    }

    public static void dropCache(UniqueName modelUin) {
        NodeSetCache cache = (NodeSetCache)ourInstances.remove(modelUin);
        if (cache != null) {
            cache.removeReferenceListener();
        }
    }

    public DesignNodeSet parse(IPath projectRelativePath) {
        return this.parse(this.getProject().getFile(projectRelativePath));
    }

    public DesignNodeSet dropNodeSet(IFile file) {
        return this.dropNodeSet(file.getProjectRelativePath());
    }

    public DesignNodeSet dropNodeSet(IPath path) {
        if (this.myNotParsablePaths.contains(path)) {
            this.myNotParsablePaths.remove(path);
            return null;
        }
        DesignNodeSet result = null;
        if (this.getWithoutFileNodeSetsMap().containsKey(path)) {
            result = (DesignNodeSet)this.getWithoutFileNodeSetsMap().remove(path);
            this.removeUnusedWithoutFilesMap();
        }
        if (result == null) {
            result = (DesignNodeSet)this.myPath2NodeSet.remove(path);
        }
        if (result != null && result.getParent() != null) {
            result.getParent().internalRemoveChildNodeSet(result);
            Iterator members = result.iterator();
            while (members.hasNext()) {
                DesignElement next = (DesignElement)members.next();
                if (!(next instanceof DesignNode)) continue;
                DesignNodeSet[] referencedNodeSets = ((DesignNode)next).getChildNodeSets();
                int i = 0;
                while (i < referencedNodeSets.length) {
                    this.dropNodeSet(referencedNodeSets[i].getFile());
                    ++i;
                }
            }
        }
        return result;
    }

    public DesignNodeSet parse(IFile file) {
        if (this.isNotParsable(file)) {
            return null;
        }
        DesignNodeSet result = this.getCachedNodeSet(file);
        if (result == null) {
            result = this.primParse(file);
            this.cache(file, result);
        }
        return result;
    }

    void cache(IFile file, DesignNodeSet nodeSet) {
        IPath path = file.getProjectRelativePath();
        if (nodeSet == null) {
            this.myNotParsablePaths.add(path);
        } else {
            this.myPath2NodeSet.put(path, nodeSet);
            Iterator members = nodeSet.iterator();
            while (members.hasNext()) {
                DesignElement next = (DesignElement)members.next();
                if (!(next instanceof DesignNode)) continue;
                DesignNodeSet[] referencedNodeSets = ((DesignNode)next).getChildNodeSets();
                int i = 0;
                while (i < referencedNodeSets.length) {
                    DesignNodeSet nextReferencedNodeSet = referencedNodeSets[i];
                    Assert.isLegal((!nextReferencedNodeSet.equals(nodeSet) ? 1 : 0) != 0, (String)"Cycle");
                    this.cache(nextReferencedNodeSet.getFile(), nextReferencedNodeSet);
                    ++i;
                }
            }
        }
    }

    public void internalAddNodeSet(IFile file, DesignNodeSet nodeSet) {
        Assert.isLegal((!file.exists() ? 1 : 0) != 0);
        Assert.isLegal((nodeSet != null ? 1 : 0) != 0);
        Assert.isLegal((this.getCachedNodeSet(file) == null ? 1 : 0) != 0);
        Assert.isLegal((!this.isNotParsable(file) ? 1 : 0) != 0);
        Assert.isLegal((!this.getWithoutFileNodeSetsMap().containsKey(file.getProjectRelativePath()) ? 1 : 0) != 0);
        this.getWithoutFileNodeSetsMap().put(file.getProjectRelativePath(), nodeSet);
    }

    private DesignNodeSet[] findWithoutFileChildren(IContainer folder) {
        LinkedList result = new LinkedList();
        Iterator allWithoutFilesEntries = NodeSetCache.getWithoutFileNodeSetsMap((IResource)folder).entrySet().iterator();
        while (allWithoutFilesEntries.hasNext()) {
            Map.Entry curEntry = allWithoutFilesEntries.next();
            IPath curPath = (IPath)curEntry.getKey();
            if (!folder.getProjectRelativePath().equals((Object)curPath.removeLastSegments(1))) continue;
            result.add(curEntry.getValue());
        }
        return result.toArray(new DesignNodeSet[result.size()]);
    }

    public static void static_beforeNodeSetFileCreation(IFile file) {
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)file);
        DesignNodeSet nodeSet = (DesignNodeSet)NodeSetCache.getWithoutFileNodeSetsMap(modelUin).remove(file.getProjectRelativePath());
        if (nodeSet != null) {
            NodeSetCache.getCache((UniqueName)modelUin).myPath2NodeSet.put(file.getProjectRelativePath(), nodeSet);
            NodeSetCache.removeUnusedWithoutFilesMap(modelUin);
        }
    }

    private DesignNodeSet primParse(IFile file) {
        DesignNodeSet result;
        if (!file.exists()) {
            return null;
        }
        NonCrypticDesignParser parser = this.getDesignParser();
        try {
            result = parser.parse(file);
        }
        catch (CoreException parsingFails) {
            parsingFails.printStackTrace();
            return null;
        }
        return result;
    }

    public NonCrypticDesignParser getDesignParser() {
        if (this.myDesignParser == null) {
            this.myDesignParser = new NonCrypticDesignParser(this);
        }
        return this.myDesignParser;
    }

    private boolean isNotParsable(IFile file) {
        return this.myNotParsablePaths.contains(file.getProjectRelativePath());
    }

    public DesignNodeSet getCachedNodeSet(IPath relativePath) {
        DesignNodeSet result = (DesignNodeSet)this.myPath2NodeSet.get(relativePath);
        if (result == null) {
            result = (DesignNodeSet)this.getWithoutFileNodeSetsMap().get(relativePath);
        }
        return result;
    }

    public DesignNodeSet getCachedNodeSet(IFile file) {
        return this.getCachedNodeSet(file.getProjectRelativePath());
    }

    public DesignElement findElement(String uin) {
        DesignElement cached = this.getCachedElement(uin);
        if (cached != null) {
            return cached;
        }
        return this.getFileFinder().findUin(DesignRootAccess.getInstance(this.getProject()).getDesignRoot(), uin);
    }

    public DesignElement getCachedElement(String uin) {
        IFile nodeSetFile;
        DesignNotion result = null;
        Iterator cachedNodeSets = this.myPath2NodeSet.values().iterator();
        while (result == null && cachedNodeSets.hasNext()) {
            DesignNodeSet curNodeSet = (DesignNodeSet)cachedNodeSets.next();
            result = curNodeSet.findMember(uin);
        }
        if (!(result == null || (nodeSetFile = result.getFile()) != null && nodeSetFile.exists())) {
            result = null;
        }
        if (result == null) {
            Iterator withoutFilesNodeSets = this.getWithoutFileNodeSetsMap().values().iterator();
            while (result == null && withoutFilesNodeSets.hasNext()) {
                DesignNodeSet curWithoutFileNodeSet = (DesignNodeSet)withoutFilesNodeSets.next();
                result = curWithoutFileNodeSet.findMember(uin);
            }
        }
        return result;
    }

    private NodeSetFileFinder getFileFinder() {
        if (this.myFileFinder == null) {
            this.myFileFinder = new NodeSetFileFinder(this);
        }
        return this.myFileFinder;
    }

    private IProject getProject() {
        return ModelUinSupport.getProject((UniqueName)this.myModelUin);
    }

    public IDesignFileNamingStrategy getNamingStrategy() {
        return this.myNamingStrategy;
    }

    public TreeDeltaBuilder getTreeDeltaBuilder() {
        if (this.myTreeDeltaBuilder == null) {
            this.myTreeDeltaBuilder = new TreeDeltaBuilder(this.myModelUin);
        }
        return this.myTreeDeltaBuilder;
    }

    public void setReferenceListener(IDesignReferenceChangeListener listener) {
        Assert.isLegal((this.myReferenceListener == null ? 1 : 0) != 0, (String)"reference listener was already setted");
        this.myReferenceListener = listener;
    }

    public void removeReferenceListener() {
        this.myReferenceListener = null;
    }

    public void referenceDeleted(DesignReference reference) {
        if (this.myReferenceListener != null) {
            this.myReferenceListener.referenceDeleted(reference);
        }
    }

    public void referenceChanged(DesignReference reference) {
        if (this.myReferenceListener != null) {
            this.myReferenceListener.referenceChanged(reference);
        }
    }

    public void referenceAdded(DesignReference reference) {
        if (this.myReferenceListener != null) {
            this.myReferenceListener.referenceAdded(reference);
        }
    }

    public void renameDesignFile(IFile file, IPath newFullPath) {
        if (this.getWithoutFileNodeSetsMap().containsKey(file.getProjectRelativePath())) {
            IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newFullPath);
            if (newFile == null || newFile.exists()) {
                return;
            }
            DesignNodeSet notSaved = (DesignNodeSet)this.getWithoutFileNodeSetsMap().remove(file.getProjectRelativePath());
            notSaved.internalSetFile(newFile);
            this.getWithoutFileNodeSetsMap().put(newFile.getProjectRelativePath(), notSaved);
        } else {
            IPath oldPath = file.getProjectRelativePath();
            try {
                file.move(newFullPath, true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException cantRename) {
                System.err.println("RENAMING fails: from; " + oldPath + " -> " + newFullPath);
                System.err.println("exception:" + (Object)((Object)cantRename));
            }
        }
    }

    public boolean canRenameDesignFile(IFile file, IPath newFullPath) {
        if (file == null || newFullPath == null) {
            return false;
        }
        IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newFullPath);
        if (newFile != null && newFile.exists()) {
            return false;
        }
        if (this.getWithoutFileNodeSetsMap().containsKey(newFullPath.removeFirstSegments(1))) {
            return false;
        }
        if (this.getWithoutFileNodeSetsMap().containsKey(file.getProjectRelativePath())) {
            return true;
        }
        return file.exists() && !file.isReadOnly();
    }

    public NodeSetIndex getIndexer() {
        return this.myIndexer;
    }

    protected DesignNodeSet[] getAllCachedNodeSets() {
        HashSet result = new HashSet((this.myPath2NodeSet.size() + this.getWithoutFileNodeSetsMap().size()) * 2);
        result.addAll(this.myPath2NodeSet.values());
        result.addAll(this.getWithoutFileNodeSetsMap().values());
        return ((AbstractCollection)result).toArray(new DesignNodeSet[result.size()]);
    }

    private Map getWithoutFileNodeSetsMap() {
        return NodeSetCache.getWithoutFileNodeSetsMap(this.myModelUin);
    }

    private void removeUnusedWithoutFilesMap() {
        NodeSetCache.removeUnusedWithoutFilesMap(this.myModelUin);
    }

    private static void removeUnusedWithoutFilesMap(UniqueName modelUin) {
        Map mayBeUnused = (Map)ourWithoutFileNodeSetsMaps.get(modelUin);
        if (mayBeUnused != null && mayBeUnused.isEmpty()) {
            ourWithoutFileNodeSetsMaps.remove(modelUin);
        }
    }

    private static Map getWithoutFileNodeSetsMap(IResource file) {
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)file);
        return NodeSetCache.getWithoutFileNodeSetsMap(modelUin);
    }

    private static Map getWithoutFileNodeSetsMap(UniqueName modelUin) {
        HashMap result = (HashMap)ourWithoutFileNodeSetsMaps.get(modelUin);
        if (result == null) {
            result = new HashMap();
            ourWithoutFileNodeSetsMaps.put(modelUin, result);
        }
        return result;
    }
}

