/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.nodeset;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IDesignVisitor;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.dom.nodeset.UndoTransparentShortCommand;
import com.tssap.selena.internal.dom.DOMPlugin;
import com.tssap.selena.internal.dom.TreeDeltaBuilder;
import com.tssap.selena.internal.dom.io.SerializeVisitor;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.ModelUinSupport;
import com.tssap.selena.model.util.various.AsyncRunner;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class DesignNodeSet {
    private boolean mySavingLockFlag;
    private int myNestedCommandsLevel;
    private boolean myChangedFlag;
    private IFile myFile;
    private DesignNode myParent;
    private HashMap myMembers = new HashMap();

    public String toString() {
        return "DesignNodeSet[" + this.hashCode() + "]: " + this.myFile.getProjectRelativePath() + ", " + (this.myFile.exists() ? "exists" : "not exists");
    }

    public boolean isReadOnly() {
        return this.getFile().isReadOnly();
    }

    private void checkMember(DesignElement element) {
        Assert.isLegal((element.getNodeSet() == this ? 1 : 0) != 0);
        Assert.isLegal((boolean)this.myMembers.containsKey(element.getId()));
    }

    public void accept(IDesignVisitor visitor) throws Exception {
        if (visitor.visitNodeSet(this)) {
            Iterator members = this.iterator();
            while (members.hasNext()) {
                ((DesignElement)members.next()).accept(visitor);
            }
        }
    }

    public void runCommand(Runnable command) {
        ++this.myNestedCommandsLevel;
        try {
            command.run();
            Object var3_2 = null;
            --this.myNestedCommandsLevel;
            if (this.myNestedCommandsLevel == 0 && this.myChangedFlag) {
                this.doSave();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            --this.myNestedCommandsLevel;
            if (this.myNestedCommandsLevel == 0 && this.myChangedFlag) {
                this.doSave();
            }
            throw throwable;
        }
    }

    public DesignNodeSet(IFile file, DesignNode parent) {
        this.myFile = file;
        this.myParent = parent;
    }

    public IFile getFile() {
        return this.myFile;
    }

    void internalSetFile(IFile newFile) {
        Assert.isLegal((newFile != null && !newFile.exists() ? 1 : 0) != 0, (String)("internalSetFile when NEW file exists:" + newFile));
        this.myFile = newFile;
    }

    public DesignNode getParent() {
        return this.myParent;
    }

    public DesignElement findMember(String id) {
        return (DesignElement)this.myMembers.get(id);
    }

    public boolean isEmpty() {
        return this.myMembers.isEmpty();
    }

    public Iterator iterator() {
        return this.myMembers.values().iterator();
    }

    public DesignNode createChildNode(String id) {
        DesignNode child = this.internalCreateChildNode(id);
        this.memberAdded(child);
        return child;
    }

    public void removeMember(DesignElement element) {
        this.checkMember(element);
        this.myMembers.remove(element.getId());
        this.memberDeleted(element);
    }

    public DesignNode internalCreateChildNode(String id) {
        if (this.myMembers.containsKey(id)) {
            throw new IllegalArgumentException("Can not create childNode: id is already used");
        }
        DesignNode child = new DesignNode(null, id, this);
        this.myMembers.put(id, child);
        this.checkMember(child);
        return child;
    }

    public void internalAddMember(DesignElement newMember) {
        this.myMembers.put(newMember.getId(), newMember);
        this.checkMember(newMember);
    }

    public void internalRemoveMember(DesignElement member) {
        this.myMembers.remove(member.getId());
    }

    public DesignView createChildView(String id) {
        return this.createChildView(id, null, true);
    }

    public DesignView createChildView(String id, Map properties, boolean update) {
        DesignView child = this.internalCreateChildView(id, properties);
        if (update) {
            this.memberAdded(child);
        }
        return child;
    }

    public DesignView internalCreateChildView(String id) {
        return this.internalCreateChildView(id, null);
    }

    public DesignView internalCreateChildView(String id, Map properties) {
        if (this.myMembers.containsKey(id)) {
            throw new IllegalArgumentException("Can not create childView: id is already used");
        }
        DesignView child = new DesignView(null, id, this, properties);
        this.myMembers.put(id, child);
        return child;
    }

    void memberAdded(DesignElement element) {
        this.getTreeDeltaBuilder().registerAdded(element);
        this.internallyChanged(false);
    }

    void memberDeleted(DesignElement element) {
        this.getTreeDeltaBuilder().registerRemoved(element);
        this.internallyChanged(false);
    }

    private TreeDeltaBuilder getTreeDeltaBuilder() {
        return this.getCache().getTreeDeltaBuilder();
    }

    public DesignElement findDesignElement(String id) {
        return (DesignElement)this.myMembers.get(id);
    }

    private void doSave() {
        if (this.myNestedCommandsLevel > 0) {
            this.myChangedFlag = true;
            return;
        }
        if (this.mySavingLockFlag) {
            return;
        }
        this.mySavingLockFlag = true;
        AsyncRunner.asyncExcec((Runnable)((Object)new UndoTransparentShortCommand(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    block7: {
                        try {
                            if (DesignNodeSet.this.myMembers.isEmpty()) {
                                DesignNodeSet.this.getCache().dropNodeSet(DesignNodeSet.this.myFile);
                                if (DesignNodeSet.this.myFile.exists()) {
                                    DesignNodeSet.this.myFile.delete(true, true, null);
                                }
                                break block7;
                            }
                            if (!DesignNodeSet.this.myFile.getProject().exists() || !DesignNodeSet.this.myFile.getProject().isAccessible() || !DesignNodeSet.this.myFile.getParent().exists()) break block7;
                            SerializeVisitor saver = new SerializeVisitor(DesignNodeSet.this);
                            if (DesignNodeSet.this.myFile.exists()) {
                                DesignNodeSet.this.myFile.setContents(saver.serialize(), false, true, null);
                                break block7;
                            }
                            NodeSetCache.static_beforeNodeSetFileCreation(DesignNodeSet.this.myFile);
                            DesignNodeSet.this.myFile.create(saver.serialize(), false, null);
                        }
                        catch (CoreException e) {
                            DOMPlugin.getDefault().logException((Exception)((Object)e));
                            Object var3_4 = null;
                            DesignNodeSet.this.myChangedFlag = false;
                            DesignNodeSet.this.mySavingLockFlag = false;
                            return;
                        }
                    }
                    Object var3_3 = null;
                    DesignNodeSet.this.myChangedFlag = false;
                    DesignNodeSet.this.mySavingLockFlag = false;
                    return;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    DesignNodeSet.this.myChangedFlag = false;
                    DesignNodeSet.this.mySavingLockFlag = false;
                    throw throwable;
                }
            }
        }));
    }

    public void internallyChanged(boolean isReferenceChanges) {
        Model model = this.getModel();
        if (model != null && !isReferenceChanges) {
            model.getExtensionManager().modelContentsChanged();
        }
        this.getCache().setFileChangesAlreadyProcessed(this.myFile, true);
        this.doSave();
    }

    private NodeSetCache getCache() {
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)this.myFile);
        return NodeSetCache.getCache(modelUin);
    }

    private Model getModel() {
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)this.myFile);
        return ModelAccess.getModel((UniqueName)modelUin);
    }
}

