/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom.nodeset;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.IDesignFileNamingStrategy;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.dom.options.NodeSetOptionSupport;
import com.tssap.selena.internal.dom.DOMPlugin;
import com.tssap.selena.internal.dom.DesignRootAccess;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DefaultNamingStrategy
implements IDesignFileNamingStrategy {
    private static final String DIAGRAM_EXTENSION_PREFIX = "txv";
    private static final String ARTIFACT_EXTENSION_PREFIX = "txa";
    private static final String DEFAULT_PACKAGE_DIAGRAM_FILE_NAME = "default";
    private static HashMap PREDEFINED_EXTENSION_SUFFIXES = new HashMap();
    private NodeSetCache myCache;

    public DefaultNamingStrategy(NodeSetCache cache) {
        this.myCache = cache;
    }

    public boolean checkNodeSetForCreateChild(Entity parent, IContainer container, String childMetaclass) {
        UniqueName diagramUin;
        DesignElement designElement;
        String activeDiagramUinAsString = parent.getPropertyValue("$ActiveDiagramUIN");
        if (activeDiagramUinAsString != null && (designElement = NameUtil.getElement(this.myCache, diagramUin = ModelAccess.createUniqueName((String)activeDiagramUinAsString))) instanceof DesignView) {
            String diagramMetaclass = DefaultNamingStrategy.getDiagramMetaclass((DesignView)designElement);
            if (this.shouldKeepTogetherWithDiagram(childMetaclass)) {
                DesignNodeSet result = designElement.getNodeSet();
                return !result.isReadOnly();
            }
        }
        return true;
    }

    public DesignNodeSet getNodeSetForCreateChild(Entity parent, IContainer container, String childMetaclass) {
        UniqueName diagramUin;
        DesignElement designElement;
        String activeDiagramUinAsString = parent.getPropertyValue("$ActiveDiagramUIN");
        if (activeDiagramUinAsString != null && (designElement = NameUtil.getElement(this.myCache, diagramUin = ModelAccess.createUniqueName((String)activeDiagramUinAsString))) instanceof DesignView) {
            String diagramMetaclass = DefaultNamingStrategy.getDiagramMetaclass((DesignView)designElement);
            if (this.shouldKeepTogetherWithDiagram(childMetaclass)) {
                DesignNodeSet result = designElement.getNodeSet();
                return result.isReadOnly() ? null : result;
            }
        }
        IFile newFile = this.createNodeSetFile(container, childMetaclass, childMetaclass, false);
        return this.internalCreateNodeSet(newFile, null);
    }

    private DesignNodeSet internalCreateNodeSet(IFile file, DesignNode parent) {
        DesignNodeSet result = new DesignNodeSet(file, parent);
        this.myCache.internalAddNodeSet(file, result);
        return result;
    }

    public DesignNodeSet getNodeSetForCreateChild(DesignNode parent, String metaclass, String name, boolean forceSeparateCreation) {
        if (forceSeparateCreation || !this.shouldKeepTogetherWithDiagram(metaclass)) {
            String namePrefix = name != null ? name : metaclass;
            IFile newFile = this.createNodeSetFile(parent.getNodeSet().getFile().getParent(), namePrefix, metaclass, false);
            return this.internalCreateNodeSet(newFile, parent);
        }
        return parent.getNodeSet();
    }

    public DesignNodeSet getDiagramNodeSet(Entity parent, IContainer container, String metaclass, String name) {
        String baseFileName = "Package Diagram".equals(metaclass) && (parent.hasPropertyValue("$metaclass", "Package") || parent instanceof Model) ? DEFAULT_PACKAGE_DIAGRAM_FILE_NAME : (name == null ? parent.getPropertyValue("$name") : name);
        IFile newFile = this.createNodeSetFile(container, baseFileName, this.getExtensionSuffix(metaclass), true);
        return this.internalCreateNodeSet(newFile, null);
    }

    public String normalizeForFileSystem(String fileNamePart) {
        return fileNamePart.replace('<', '_').replace('>', '_').replace('/', '_').replace('\\', '_').replace('&', '_').replace('%', '_').replace(':', '_');
    }

    private IFile createNodeSetFile(IContainer folder, String namePrefix, String extSuffix, boolean isDiagramFile) {
        if ("com".equals(namePrefix)) {
            namePrefix = "_" + namePrefix;
        }
        Assert.isLegal((folder != null ? 1 : 0) != 0);
        namePrefix = this.normalizeForFileSystem(namePrefix);
        String extension = this.createFileExtension(extSuffix, isDiagramFile);
        int nameSuffix = isDiagramFile ? 0 : 1;
        String curFileName;
        IFile mayBeExistingFile;
        while ((mayBeExistingFile = folder.getFile((IPath)new Path(curFileName = nameSuffix == 0 ? namePrefix + "." + extension : namePrefix + nameSuffix + "." + extension))).exists() || this.myCache.getCachedNodeSet(mayBeExistingFile) != null) {
            ++nameSuffix;
        }
        return mayBeExistingFile;
    }

    public boolean isNodeSetFile(IResource resource) {
        if (resource.getType() == 1 && DesignRootAccess.getInstance(resource.getProject()).isUnderDesignRoot(resource.getProjectRelativePath())) {
            String extension = ((IFile)resource).getFileExtension();
            return extension != null && (extension.startsWith(DIAGRAM_EXTENSION_PREFIX) || extension.startsWith(ARTIFACT_EXTENSION_PREFIX));
        }
        return false;
    }

    private String createFileExtension(String extSuffix, boolean isDiagramFile) {
        String result = isDiagramFile ? DIAGRAM_EXTENSION_PREFIX : ARTIFACT_EXTENSION_PREFIX;
        return this.normalizeForFileSystem(result + extSuffix);
    }

    private boolean shouldKeepTogetherWithDiagram(String elementMetaclass) {
        return !NodeSetOptionSupport.getInstance().isStoreSeparately(elementMetaclass);
    }

    private static String getDiagramMetaclass(DesignView view) {
        DesignProperty[] metaclasses = view.getProperties("$metaclass");
        if (metaclasses.length > 0) {
            return metaclasses[0].getValue();
        }
        return null;
    }

    private String getExtensionSuffix(String diagramMetaclass) {
        String result = DOMPlugin.getDefault().getDiagramFileExtensionHint(diagramMetaclass);
        if (result == null) {
            result = (String)PREDEFINED_EXTENSION_SUFFIXES.get(diagramMetaclass);
        }
        return result != null ? this.normalizeForFileSystem(result) : this.normalizeForFileSystem(diagramMetaclass);
    }

    static {
        PREDEFINED_EXTENSION_SUFFIXES.put("Class Diagram", "cls");
        PREDEFINED_EXTENSION_SUFFIXES.put("Package Diagram", "pck");
        PREDEFINED_EXTENSION_SUFFIXES.put("Use Case Diagram", "use");
        PREDEFINED_EXTENSION_SUFFIXES.put("Sequence Diagram", "seq");
        PREDEFINED_EXTENSION_SUFFIXES.put("Deployment Diagram", "dpl");
        PREDEFINED_EXTENSION_SUFFIXES.put("Component Diagram", "cmp");
        PREDEFINED_EXTENSION_SUFFIXES.put("Activity Diagram", "act");
        PREDEFINED_EXTENSION_SUFFIXES.put("State Diagram", "stc");
    }
}

