/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignReferenceContainer;
import com.tssap.selena.dom.IDesignVisitor;
import com.tssap.selena.dom.IReferenceContainer;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DesignView
extends DesignElement
implements IReferenceContainer {
    private DesignReferenceContainer myReferenceContainer = new DesignReferenceContainer(this, this);

    public DesignView(DesignNode parent, String id, DesignNodeSet nodeSet) {
        this(parent, id, nodeSet, null);
    }

    public DesignView(DesignNode parent, String id, DesignNodeSet nodeSet, Map properties) {
        super(parent, id, nodeSet);
        if (properties != null) {
            this.initProperties(properties);
        }
    }

    protected void initProperties(Map properties) {
        Iterator names = properties.keySet().iterator();
        while (names.hasNext()) {
            String name = names.next().toString();
            Object value = properties.get(name);
            if (value == null) continue;
            this.internalCreateProperty(name, value.toString());
        }
    }

    public DesignReference[] findInnerReferences(String proxyId) {
        HashSet results = new HashSet();
        DesignView.findInnerReferences(this, proxyId, results);
        return ((AbstractCollection)results).toArray(new DesignReference[results.size()]);
    }

    private static void findInnerReferences(IReferenceContainer container, String proxyId, Collection results) {
        DesignReference[] inners = container.getReferences();
        int i = 0;
        while (i < inners.length) {
            DesignReference curInner = inners[i];
            if (proxyId.equals(curInner.getProxyId())) {
                results.add(curInner);
            } else {
                DesignView.findInnerReferences(curInner, proxyId, results);
            }
            ++i;
        }
    }

    public DesignView getDesignView() {
        return this;
    }

    public DesignReference addReference(String proxyId) {
        return this.myReferenceContainer.addReference(proxyId);
    }

    public DesignReference internalAddReference(String proxyId) {
        return this.myReferenceContainer.internalAddReference(proxyId);
    }

    public void removeReferenceByProxyId(String proxyId) {
        this.myReferenceContainer.removeReferenceByProxyId(proxyId);
    }

    public DesignReference[] getReferences() {
        return this.myReferenceContainer.getReferences();
    }

    public DesignReference getReferenceByProxyId(String proxyId) {
        return this.myReferenceContainer.getReferenceByProxyId(proxyId);
    }

    public void internalChangeProxyId(DesignReference designReference, String newProxyId) {
        this.myReferenceContainer.internalChangeProxyId(designReference, newProxyId);
    }

    public void referenceAdded(DesignReference childReference) {
        this.getCache().referenceAdded(childReference);
        this.getNodeSet().internallyChanged(true);
    }

    public void referenceChanged(DesignReference childReference) {
        this.getCache().referenceChanged(childReference);
        this.getNodeSet().internallyChanged(true);
    }

    public void referenceRemoved(DesignReference childReference) {
        this.getCache().referenceDeleted(childReference);
        this.getNodeSet().internallyChanged(true);
    }

    public void accept(IDesignVisitor visitor) throws Exception {
        if (visitor.visitView(this)) {
            Iterator it = this.getChildNotions().iterator();
            while (it.hasNext()) {
                ((DesignReference)it.next()).accept(visitor);
            }
        }
    }

    public Collection getChildNotions() {
        return Arrays.asList(this.getReferences());
    }
}

