/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom;

import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IReferenceContainer;
import com.tssap.selena.model.util.Assert;
import java.util.Collection;
import java.util.HashMap;

public class DesignReferenceContainer
implements IReferenceContainer {
    private IReferenceContainer myHost;
    private DesignView myView = null;
    private HashMap myProxyIds2References = new HashMap();

    public DesignReferenceContainer(IReferenceContainer host, DesignView view) {
        Assert.isLegal((host != null ? 1 : 0) != 0, (String)"host == null");
        Assert.isLegal((view != null ? 1 : 0) != 0, (String)"parent view == null");
        this.myHost = host;
        this.myView = view;
    }

    public DesignView getDesignView() {
        if (this.myView == null) {
            this.myView = this.myHost.getDesignView();
            Assert.isLegal((this.myView != null ? 1 : 0) != 0, (String)"can not find parent DesignView");
        }
        return this.myView;
    }

    public DesignReference addReference(String proxyId) {
        DesignReference result = this.internalAddReference(proxyId);
        this.referenceAdded(result);
        return result;
    }

    public DesignReference internalAddReference(String proxyId) {
        DesignReference result = new DesignReference(this.getDesignView(), this.myHost, proxyId);
        this.myProxyIds2References.put(proxyId, result);
        return result;
    }

    public void removeReferenceByProxyId(String proxyId) {
        DesignReference toRemove = this.getReferenceByProxyId(proxyId);
        if (toRemove != null) {
            this.myProxyIds2References.remove(proxyId);
        }
        this.referenceRemoved(toRemove);
    }

    public DesignReference[] getReferences() {
        Collection references = this.myProxyIds2References.values();
        return references.toArray(new DesignReference[references.size()]);
    }

    public DesignReference getReferenceByProxyId(String proxyId) {
        return (DesignReference)this.myProxyIds2References.get(proxyId);
    }

    public void internalChangeProxyId(DesignReference reference, String newProxyId) {
        if (this.myProxyIds2References.containsKey(newProxyId)) {
            System.err.println("internalChjangeProxuID: attempt to change proxyId to already exists one");
            System.err.println("designRefContainer: " + this.myHost);
            System.err.println("newReferenceID = " + reference.getProxyId());
            System.err.println("newParentID = " + newProxyId);
            System.err.println("already exists with this id:" + this.myProxyIds2References.get(newProxyId));
        }
        this.myProxyIds2References.remove(reference.getProxyId());
        reference.internalSetProxyId(newProxyId);
        this.myProxyIds2References.put(newProxyId, reference);
    }

    public void referenceAdded(DesignReference reference) {
        this.getDesignView().referenceAdded(reference);
    }

    public void referenceChanged(DesignReference reference) {
        this.getDesignView().referenceChanged(reference);
    }

    public void referenceRemoved(DesignReference reference) {
        this.getDesignView().referenceRemoved(reference);
    }
}

