/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom;

import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProxy;
import com.tssap.selena.dom.DesignReferenceContainer;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IDesignVisitor;
import com.tssap.selena.dom.IReferenceContainer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class DesignReference
extends DesignProxy
implements IReferenceContainer {
    private IReferenceContainer myContainer;
    private IReferenceContainer myParentContainer;

    public DesignReference(DesignView parent, IReferenceContainer parentContainer, String proxyId) {
        super((DesignNotion)parent, proxyId);
        this.myParentContainer = parentContainer == null ? parent : parentContainer;
        this.myContainer = new DesignReferenceContainer(this, parent);
    }

    public void delete() {
        super.delete();
    }

    public IReferenceContainer getParentContainer() {
        return this.myParentContainer;
    }

    public DesignView getDesignView() {
        return this.getParentContainer().getDesignView();
    }

    public DesignReference addReference(String proxyId) {
        return this.myContainer.addReference(proxyId);
    }

    public DesignReference internalAddReference(String proxyId) {
        return this.myContainer.internalAddReference(proxyId);
    }

    public void removeReferenceByProxyId(String proxyId) {
        this.myContainer.removeReferenceByProxyId(proxyId);
    }

    public DesignReference[] getReferences() {
        return this.myContainer.getReferences();
    }

    public Collection getChildNotions() {
        return Arrays.asList(this.getReferences());
    }

    public DesignReference getReferenceByProxyId(String proxyId) {
        return this.myContainer.getReferenceByProxyId(proxyId);
    }

    public void internalChangeProxyId(DesignReference designReference, String newProxyId) {
        this.myContainer.internalChangeProxyId(designReference, newProxyId);
    }

    void internalSetProxyId(String proxyId) {
        super.internalSetProxyId(proxyId);
        this.getParent().internallyChanged(true);
    }

    public void referenceAdded(DesignReference childReference) {
        this.getDesignView().referenceAdded(childReference);
    }

    public void referenceChanged(DesignReference childReference) {
        this.getDesignView().referenceChanged(childReference);
    }

    public void referenceRemoved(DesignReference childReference) {
        this.getDesignView().referenceRemoved(childReference);
    }

    protected void propertyChanged() {
        this.getParentContainer().referenceChanged(this);
    }

    protected void internalDelete() {
        this.getParentContainer().removeReferenceByProxyId(this.getProxyId());
    }

    public void accept(IDesignVisitor visitor) throws Exception {
        if (visitor.visitReference(this)) {
            Iterator<DesignReference> subReferences = Arrays.asList(this.getReferences()).iterator();
            while (subReferences.hasNext()) {
                subReferences.next().accept(visitor);
            }
        }
    }
}

