/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom;

import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.IDesignVisitor;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.ModelUinSupport;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public abstract class DesignNotion {
    private ArrayList myProperties = new ArrayList();
    private DesignNotion myParent;
    private DesignNodeSet myNodeSet;

    protected DesignNotion(DesignNotion parent, DesignNodeSet nodeSet) {
        if (nodeSet == null) {
            throw new NullPointerException("DesignNotion::<init> -- NodeSet == null");
        }
        this.myParent = parent;
        this.myNodeSet = nodeSet;
    }

    protected DesignNotion(DesignNotion parent) {
        this(parent, parent.getNodeSet());
    }

    protected void internalSetParent(DesignNotion parent) {
        if (this.myParent != null && this.myParent != parent) {
            throw new IllegalStateException("attempt to add second parent");
        }
        this.myParent = parent;
    }

    public void internalChangeNodeSet(DesignNodeSet newNodeSet) {
        this.myNodeSet = newNodeSet;
    }

    public DesignNodeSet getNodeSet() {
        return this.myNodeSet;
    }

    public boolean isReadOnly() {
        return this.getNodeSet().isReadOnly();
    }

    public final void runCommand(Runnable command) {
        this.getNodeSet().runCommand(command);
    }

    public DesignProperty createProperty(String name, String value) {
        DesignProperty property = this.internalCreateProperty(name, value);
        this.propertyChanged();
        return property;
    }

    public DesignProperty internalCreateProperty(String name, String value) {
        DesignProperty property = new DesignProperty(name, value, this);
        this.myProperties.add(property);
        return property;
    }

    public DesignProperty[] getProperties() {
        return this.myProperties.toArray(new DesignProperty[this.myProperties.size()]);
    }

    public DesignProperty[] getProperties(String name) {
        if (name == null) {
            return this.getProperties();
        }
        ArrayList<DesignProperty> properties = new ArrayList<DesignProperty>();
        Iterator it = ((AbstractList)this.myProperties).iterator();
        while (it.hasNext()) {
            DesignProperty next = (DesignProperty)it.next();
            if (!name.equals(next.getName())) continue;
            properties.add(next);
        }
        return properties.toArray(new DesignProperty[properties.size()]);
    }

    public void removeProperty(DesignProperty property) {
        if (property.getOwner() == this) {
            ((AbstractCollection)this.myProperties).remove(property);
            property.disassociate();
            this.propertyChanged();
        }
    }

    public final DesignNotion getParent() {
        if (this.myParent != null) {
            return this.myParent;
        }
        return this.myNodeSet.getParent();
    }

    public void delete() {
        this.internalDelete();
    }

    public final IFile getFile() {
        return this.getNodeSet().getFile();
    }

    protected NodeSetCache getCache() {
        UniqueName modelUin = ModelUinSupport.createModelUin((IResource)this.getFile());
        return NodeSetCache.getCache(modelUin);
    }

    public abstract void accept(IDesignVisitor var1) throws Exception;

    protected void disassociate() {
        this.myParent = null;
    }

    protected abstract void internalDelete();

    public final void internallyChanged(boolean isReferenceChanges) {
        this.getNodeSet().internallyChanged(isReferenceChanges);
    }

    protected void propertyChanged() {
        this.getCache().getTreeDeltaBuilder().registerChanged(this);
        this.internallyChanged(false);
    }

    public abstract Collection getChildNotions();

    public static boolean hasDesignProperty(DesignNotion owner, String propertyName) {
        Iterator properties = ((AbstractList)owner.myProperties).iterator();
        while (properties.hasNext()) {
            DesignProperty next = (DesignProperty)properties.next();
            if (next == null || !propertyName.equals(next.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDesignPropertyValue(DesignNotion owner, String propertyName, String propertyValue) {
        Iterator properties = ((AbstractList)owner.myProperties).iterator();
        while (properties.hasNext()) {
            DesignProperty next = (DesignProperty)properties.next();
            if (next == null || !propertyName.equals(next.getName()) || !propertyValue.equals(next.getValue())) continue;
            return true;
        }
        return false;
    }
}

