/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IDesignVisitor;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.model.util.Assert;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class DesignNode
extends DesignElement {
    private static final DesignNodeSet[] NO_NODESETS = new DesignNodeSet[0];
    private final HashMap myChildren = new HashMap();
    private final HashSet myChildNodeSets = new HashSet();
    static /* synthetic */ Class class$com$tssap$selena$dom$DesignElement;
    static /* synthetic */ Class class$com$tssap$selena$dom$DesignNode;
    static /* synthetic */ Class class$com$tssap$selena$dom$DesignLink;
    static /* synthetic */ Class class$com$tssap$selena$dom$DesignView;

    public DesignNode(DesignNode parent, String id, DesignNodeSet nodeSet) {
        super(parent, id, nodeSet);
    }

    public DesignNode createChildNode(String id, String metaclass) {
        DesignNode child;
        DesignNodeSet childNodeSet = this.getCache().getNamingStrategy().getNodeSetForCreateChild(this, metaclass, null, false);
        if (childNodeSet == this.getNodeSet()) {
            child = this.internalCreateChildNode(id);
            this.childAdded(child);
        } else {
            this.myChildNodeSets.add(childNodeSet);
            child = childNodeSet.createChildNode(id);
            this.internallyChanged(false);
        }
        return child;
    }

    public DesignNode internalCreateChildNode(String id) {
        if (this.myChildren.containsKey(id)) {
            throw new IllegalArgumentException("This id is already used");
        }
        DesignNode child = new DesignNode(this, id, this.getNodeSet());
        this.myChildren.put(id, child);
        return child;
    }

    public void internalAddChildNodeSet(DesignNodeSet childNodeSet) {
        Assert.isLegal((childNodeSet.getParent() == this ? 1 : 0) != 0, (String)"attempt to add child node set with wrong parent");
        Iterator existsNodeSets = this.myChildNodeSets.iterator();
        while (existsNodeSets.hasNext()) {
            DesignNodeSet nextExists = (DesignNodeSet)existsNodeSets.next();
            Assert.isLegal((!childNodeSet.getFile().getProjectRelativePath().equals((Object)nextExists.getFile().getProjectRelativePath()) ? 1 : 0) != 0, (String)"bug while fixing scr#7360 p4ChList#16052");
        }
        this.myChildNodeSets.add(childNodeSet);
    }

    public void internalAddChild(DesignElement newChild) {
        if (this.myChildren.containsKey(newChild.getId())) {
            throw new IllegalArgumentException("This id is alread used");
        }
        newChild.internalSetParent(this);
        this.myChildren.put(newChild.getId(), newChild);
    }

    public DesignLink createChildLink(String id) {
        DesignLink child = this.internalCreateChildLink(id);
        this.childAdded(child);
        return child;
    }

    public DesignLink internalCreateChildLink(String id) {
        if (this.myChildren.containsKey(id)) {
            throw new IllegalArgumentException("This id is alread used");
        }
        DesignLink child = new DesignLink(this, id);
        this.myChildren.put(id, child);
        return child;
    }

    public DesignView createChildView(String id) {
        DesignView child = this.internalCreateChildView(id);
        this.childAdded(child);
        return child;
    }

    public DesignView internalCreateChildView(String id) {
        if (this.myChildren.containsKey(id)) {
            throw new IllegalArgumentException("This id is alread used");
        }
        DesignView child = new DesignView(this, id, null);
        this.myChildren.put(id, child);
        return child;
    }

    public DesignElement getChild(String id) {
        DesignElement result = (DesignElement)this.myChildren.get(id);
        if (result != null) {
            return result;
        }
        Iterator childNodeSets = this.myChildNodeSets.iterator();
        while (result == null && childNodeSets.hasNext()) {
            DesignNodeSet curNodeSet = (DesignNodeSet)childNodeSets.next();
            result = curNodeSet.findDesignElement(id);
        }
        return result;
    }

    public DesignElement[] getChildren() {
        return (DesignElement[])this.getChildren(class$com$tssap$selena$dom$DesignElement == null ? (class$com$tssap$selena$dom$DesignElement = DesignNode.class$("com.tssap.selena.dom.DesignElement")) : class$com$tssap$selena$dom$DesignElement);
    }

    public DesignNode[] getChildNodes() {
        return (DesignNode[])this.getChildren(class$com$tssap$selena$dom$DesignNode == null ? (class$com$tssap$selena$dom$DesignNode = DesignNode.class$("com.tssap.selena.dom.DesignNode")) : class$com$tssap$selena$dom$DesignNode);
    }

    public DesignNodeSet[] getChildNodeSets() {
        return this.myChildNodeSets.isEmpty() ? NO_NODESETS : ((AbstractCollection)this.myChildNodeSets).toArray(new DesignNodeSet[this.myChildNodeSets.size()]);
    }

    public void internalRemoveChildNodeSet(DesignNodeSet childNodeSet) {
        this.myChildNodeSets.remove(childNodeSet);
    }

    public DesignLink[] getChildLinks() {
        return (DesignLink[])this.getChildren(class$com$tssap$selena$dom$DesignLink == null ? (class$com$tssap$selena$dom$DesignLink = DesignNode.class$("com.tssap.selena.dom.DesignLink")) : class$com$tssap$selena$dom$DesignLink);
    }

    public DesignView[] getChildViews() {
        return (DesignView[])this.getChildren(class$com$tssap$selena$dom$DesignView == null ? (class$com$tssap$selena$dom$DesignView = DesignNode.class$("com.tssap.selena.dom.DesignView")) : class$com$tssap$selena$dom$DesignView);
    }

    private Object[] getChildren(Class clazz) {
        ArrayList<Object> children = new ArrayList<Object>();
        Iterator it = this.myChildren.values().iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!clazz.isInstance(element)) continue;
            children.add(element);
        }
        Iterator childNodeSets = this.myChildNodeSets.iterator();
        while (childNodeSets.hasNext()) {
            DesignNodeSet curNodeSet = (DesignNodeSet)childNodeSets.next();
            Iterator members = curNodeSet.iterator();
            while (members.hasNext()) {
                DesignElement curMember = (DesignElement)members.next();
                if (!clazz.isInstance(curMember)) continue;
                children.add(curMember);
            }
        }
        return children.toArray((Object[])Array.newInstance(clazz, children.size()));
    }

    protected void removeAllChildren() {
        LinkedList collectedChildren = new LinkedList();
        collectedChildren.addAll(this.getChildNotions());
        Iterator children = collectedChildren.iterator();
        while (children.hasNext()) {
            this.removeChild((DesignElement)children.next());
        }
    }

    protected void removeChild(final DesignElement child) {
        this.runCommand(new Runnable(){

            public void run() {
                if (child instanceof DesignNode) {
                    ((DesignNode)child).removeAllChildren();
                }
                if (DesignNode.this.myChildren.containsKey(child.getId())) {
                    DesignNode.this.myChildren.remove(child.getId());
                    DesignNode.this.childDeleted(child);
                } else {
                    DesignNodeSet childsNodeSet = child.getNodeSet();
                    Assert.isLegal((boolean)DesignNode.this.myChildNodeSets.contains(childsNodeSet), (String)"attempt to delete child with unknown nodeSet");
                    childsNodeSet.removeMember(child);
                    if (!childsNodeSet.iterator().hasNext()) {
                        DesignNode.this.myChildNodeSets.remove(childsNodeSet);
                    }
                }
            }
        });
    }

    public void accept(IDesignVisitor visitor) throws Exception {
        if (visitor.visitNode(this)) {
            Iterator it = this.myChildren.values().iterator();
            while (it.hasNext()) {
                ((DesignElement)it.next()).accept(visitor);
            }
        }
    }

    void childAdded(DesignElement element) {
        this.getCache().getTreeDeltaBuilder().registerAdded(element);
        this.internallyChanged(false);
    }

    void childDeleted(DesignElement element) {
        this.getCache().getTreeDeltaBuilder().registerRemoved(element);
        this.internallyChanged(false);
    }

    public Collection getChildNotions() {
        return Arrays.asList(this.getChildren());
    }

    public boolean canExtractToSeparateNodeSet() {
        DesignNotion parent = this.getParent();
        return parent != null && this.getNodeSet().equals(parent.getNodeSet()) && (this.getMetaclass() != null || this.getName() != null);
    }

    public boolean canCombineWithParentNodeSet() {
        DesignNotion parent = this.getParent();
        return parent != null && !this.getNodeSet().equals(parent.getNodeSet());
    }

    public void extractToSeparateNodeSet() {
        DesignNode parent = (DesignNode)this.getParent();
        if (parent == null || !this.getNodeSet().equals(parent.getNodeSet())) {
            return;
        }
        DesignNodeSet newNodeSet = this.getCache().getNamingStrategy().getNodeSetForCreateChild(parent, this.getMetaclass(), this.getName(), true);
        DesignNodeSet oldNodeSet = this.getNodeSet();
        Assert.isLegal((newNodeSet != null && !newNodeSet.getFile().getFullPath().equals((Object)oldNodeSet.getFile().getFullPath()) ? 1 : 0) != 0);
        oldNodeSet.internalRemoveMember(this);
        if (oldNodeSet.isEmpty()) {
            parent.myChildNodeSets.remove(oldNodeSet);
        }
        this.internalChangeNodeSet(newNodeSet);
        newNodeSet.internalAddMember(this);
        parent.myChildren.remove(this.getId());
        parent.myChildNodeSets.add(newNodeSet);
        newNodeSet.internallyChanged(false);
        oldNodeSet.internallyChanged(false);
    }

    public void combineWithParentNodeSet() {
        DesignNode parent = (DesignNode)this.getParent();
        if (parent == null || this.getNodeSet().equals(parent.getNodeSet())) {
            return;
        }
        DesignNodeSet newNodeSet = parent.getNodeSet();
        DesignNodeSet oldNodeSet = this.getNodeSet();
        Assert.isLegal((newNodeSet != null && !newNodeSet.getFile().getFullPath().equals((Object)oldNodeSet.getFile().getFullPath()) ? 1 : 0) != 0);
        oldNodeSet.internalRemoveMember(this);
        if (oldNodeSet.isEmpty()) {
            parent.myChildNodeSets.remove(oldNodeSet);
        }
        parent.myChildren.put(this.getId(), this);
        this.internalChangeNodeSet(newNodeSet);
        newNodeSet.internallyChanged(false);
        oldNodeSet.internallyChanged(false);
    }

    protected DesignLink[] findIncomingLinks() {
        DesignLink[] ownLinks = super.findIncomingLinks();
        HashSet<DesignLink> result = new HashSet<DesignLink>((ownLinks.length + 1) * 3);
        result.addAll(Arrays.asList(ownLinks));
        DesignElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            DesignLink[] curIncomingLinks = children[i].findIncomingLinks();
            result.addAll(Arrays.asList(curIncomingLinks));
            ++i;
        }
        return ((AbstractCollection)result).toArray(new DesignLink[result.size()]);
    }

    private String getMetaclass() {
        return DesignNode.getPropertyValue(this, "$metaclass");
    }

    private String getName() {
        return DesignNode.getPropertyValue(this, "$name");
    }

    private static String getPropertyValue(DesignNotion notion, String propertyName) {
        DesignProperty[] values = notion.getProperties(propertyName);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0].getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

