/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.dom;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignParticipant;
import com.tssap.selena.dom.IDesignVisitor;
import java.util.ArrayList;
import java.util.Collection;

public class DesignLink
extends DesignElement {
    private DesignParticipant mySource;
    private DesignParticipant myTarget;

    public DesignLink(DesignNode parent, String id) {
        super(parent, id, parent.getNodeSet());
    }

    public DesignParticipant createSource(String participantId) {
        this.internalCreateSource(participantId);
        this.endsChanged();
        return this.mySource;
    }

    public DesignParticipant internalCreateSource(String participantId) {
        this.removeSource();
        this.mySource = new DesignParticipant(this, true, participantId);
        return this.mySource;
    }

    public DesignParticipant createTarget(String participantId) {
        this.internalCreateTarget(participantId);
        this.endsChanged();
        return this.myTarget;
    }

    public DesignParticipant internalCreateTarget(String participantId) {
        this.removeTarget();
        this.myTarget = new DesignParticipant(this, false, participantId);
        return this.myTarget;
    }

    public DesignParticipant getSource() {
        return this.mySource;
    }

    public DesignParticipant getTarget() {
        return this.myTarget;
    }

    public void removeParticipant(DesignParticipant participant) {
        if (participant == this.mySource) {
            this.removeSource();
            this.endsChanged();
        } else if (participant == this.myTarget) {
            this.removeTarget();
            this.endsChanged();
        }
    }

    public void accept(IDesignVisitor visitor) throws Exception {
        if (visitor.visitLink(this)) {
            this.mySource.accept(visitor);
            this.myTarget.accept(visitor);
        }
    }

    private void removeSource() {
        if (this.mySource != null) {
            this.mySource.disassociate();
        }
        this.mySource = null;
    }

    private void removeTarget() {
        if (this.myTarget != null) {
            this.myTarget.disassociate();
        }
        this.myTarget = null;
    }

    void endsChanged() {
        this.getCache().getTreeDeltaBuilder().registerChanged(this);
        this.internallyChanged(false);
    }

    public Collection getChildNotions() {
        ArrayList<DesignParticipant> children = new ArrayList<DesignParticipant>();
        if (this.mySource != null) {
            children.add(this.mySource);
        }
        if (this.myTarget != null) {
            children.add(this.myTarget);
        }
        return children;
    }
}

