/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.boot;

import com.sap.engine.boot.CoverageClassModifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ModificationFactory {
    public static int COUNT_OF_ALL_METHODS;
    public static int SIZE;
    public static String[] NAMES;
    public static long[] CALLS;
    private static String[] exclude;
    private static String[] include;
    private static String[] excludePackage;
    private static String[] includePackage;
    private static final String INCLUDE_PREFIX = "include.";
    private static final String EXCLUDE_PREFIX = "exclude.";
    private static CoverageClassModifier modifier;

    public static void init(Properties p) {
        ModificationFactory.initFilter(p);
        SIZE = 150000;
        NAMES = new String[SIZE];
        CALLS = new long[SIZE];
    }

    private static void initFilter(Properties props) {
        Vector<String> include = new Vector<String>();
        Vector<String> exclude = new Vector<String>();
        Vector<String> includePackage = new Vector<String>();
        Vector<String> excludePackage = new Vector<String>();
        String key = null;
        String value = null;
        Enumeration enumeration = ((Hashtable)props).keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            value = ((String)((Hashtable)props).get(key)).trim();
            if (key.startsWith(INCLUDE_PREFIX)) {
                if (value.endsWith(".*")) {
                    includePackage.add(value.substring(0, value.length() - 1));
                    continue;
                }
                include.add(value);
                continue;
            }
            if (!key.startsWith(EXCLUDE_PREFIX)) continue;
            if (value.endsWith(".*")) {
                excludePackage.add(value.substring(0, value.length() - 1));
                continue;
            }
            exclude.add(value);
        }
        ModificationFactory.include = new String[include.size()];
        include.copyInto(ModificationFactory.include);
        ModificationFactory.includePackage = new String[includePackage.size()];
        includePackage.copyInto(ModificationFactory.includePackage);
        ModificationFactory.exclude = new String[exclude.size()];
        exclude.copyInto(ModificationFactory.exclude);
        ModificationFactory.excludePackage = new String[excludePackage.size()];
        excludePackage.copyInto(ModificationFactory.excludePackage);
    }

    public static boolean accept(String className) {
        int ind = className.lastIndexOf(".");
        if (ind != -1) {
            String classPackage = className.substring(0, ind + 1);
            int i = 0;
            while (i < includePackage.length) {
                if (classPackage.startsWith(includePackage[i])) {
                    int y = 0;
                    while (y < excludePackage.length) {
                        if (classPackage.startsWith(excludePackage[y])) {
                            return false;
                        }
                        ++y;
                    }
                    int y2 = 0;
                    while (y2 < exclude.length) {
                        if (className.equals(exclude[y2])) {
                            return false;
                        }
                        ++y2;
                    }
                    return true;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < include.length) {
                if (classPackage.equals(include[i2])) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public static CoverageClassModifier getModificator(Object loader) throws Exception {
        return modifier;
    }

    static {
        modifier = new CoverageClassModifier();
    }
}

