/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IStorage;
import org.eclipse.swt.internal.ole.win32.IStream;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;

final class OleFile {
    IStorage rootStorage;
    File file;
    String streamName;
    static int READ = 0;
    static int WRITE = 1;

    OleFile(File file, String streamName, int mode) {
        if (file == null || file.isDirectory()) {
            OLE.error(5);
        }
        this.file = file;
        this.streamName = streamName;
        if (mode == READ) {
            this.openForRead();
        }
        if (mode == WRITE) {
            this.openForWrite();
        }
    }

    void dispose() {
        this.rootStorage.Release();
        this.rootStorage = null;
        this.file = null;
        this.streamName = null;
    }

    IStorage getRootStorage() {
        return this.rootStorage;
    }

    private void openForRead() {
        if (!this.file.exists()) {
            return;
        }
        char[] path = (String.valueOf(this.file.getAbsolutePath()) + "\u0000").toCharArray();
        if (COM.StgIsStorageFile(path) == 0) {
            this.readStorageFile(path);
        } else {
            this.readTraditionalFile(path);
        }
    }

    private void openForWrite() {
        IStorage storage;
        int[] address;
        int mode;
        char[] filePath = (String.valueOf(this.file.getAbsolutePath()) + "\u0000").toCharArray();
        int result = COM.StgCreateDocfile(filePath, mode = 69650, 0, address = new int[1]);
        if (result != 0) {
            OLE.error(1000, result);
        }
        this.rootStorage = storage = new IStorage(address[0]);
    }

    private void readStorageFile(char[] path) {
        int mode = 65552;
        int[] address = new int[1];
        int result = COM.StgOpenStorage(path, 0, mode, 0, 0, address);
        if (result != 0) {
            OLE.error(1002, result);
        }
        this.rootStorage = new IStorage(address[0]);
        this.rootStorage.AddRef();
    }

    private void readTraditionalFile(char[] path) {
        int[] address;
        int mode;
        int result;
        if (this.streamName == null) {
            OLE.error(4);
        }
        if ((result = COM.StgCreateDocfile(null, (mode = 4114) | 0x4000000, 0, address = new int[1])) != 0) {
            OLE.error(1002, result);
        }
        this.rootStorage = new IStorage(address[0]);
        this.rootStorage.AddRef();
        address = new int[1];
        result = this.rootStorage.CreateStream(this.streamName, mode, 0, 0, address);
        if (result != 0) {
            OLE.error(1002, result);
        }
        IStream stream = new IStream(address[0]);
        stream.AddRef();
        try {
            FileInputStream fileInput = new FileInputStream(this.file);
            int increment = 4096;
            byte[] buffer = new byte[increment];
            int count = 0;
            while ((count = fileInput.read(buffer)) > 0) {
                int pv = COM.CoTaskMemAlloc(count);
                OS.MoveMemory(pv, buffer, count);
                result = stream.Write(pv, count, null);
                COM.CoTaskMemFree(pv);
                if (result == 0) continue;
                OLE.error(1002, result);
            }
            stream.Commit(0);
            fileInput.close();
        }
        catch (IOException iOException) {
            OLE.error(1002);
        }
        stream.Release();
    }
}

