/*
 * Decompiled with CFR 0.152.
 */
package dcnames;

import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.requests.ParserException;
import com.tssap.dtr.client.lib.protocol.requests.http.GetRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.OptionsRequest;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.util.Query;
import dcnames.Console;
import dcnames.Interpreter;
import dcnames.SaxHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class DcDiffInterpreter
implements Interpreter {
    private static final String PROMPT = "DCDiff> ";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String EXIT = "exit";
    private static final String CTRLC = "\u0003";
    private static final String CTRLY = "\u0019";
    private static final String DIFF = "diff";
    private Connection con;
    private XMLReader saxParser;
    private Collection errors;

    public boolean parseInput(String aLine, Console console) {
        boolean quit;
        ArrayList<String> result = new ArrayList<String>();
        this.errors = new ArrayList();
        if (aLine == null) {
            aLine = "";
        }
        StringTokenizer tokenizer = new StringTokenizer(aLine.trim(), " ");
        String command = null;
        if (tokenizer.hasMoreTokens()) {
            command = tokenizer.nextToken();
        }
        boolean bl = quit = command == null || command.equalsIgnoreCase(EXIT) || command.equals(CTRLC) || command.equals(CTRLY);
        if (quit) {
            result.add(NEW_LINE);
        } else {
            try {
                if (command.equalsIgnoreCase(DIFF)) {
                    String wsp1 = null;
                    String wsp2 = null;
                    Collection diff = null;
                    if (!tokenizer.hasMoreTokens()) {
                        this.errors.add("   first workspace path unspecified");
                    } else {
                        wsp1 = tokenizer.nextToken();
                    }
                    if (!tokenizer.hasMoreTokens()) {
                        this.errors.add("   second workspace path unspecified");
                    } else {
                        wsp2 = tokenizer.nextToken();
                    }
                    if (wsp1 != null && wsp2 != null) {
                        result.add("Comparing DCs contained in following workspaces");
                        result.add("   " + wsp1);
                        result.add("   " + wsp2);
                        diff = this.dcDiff(wsp1, wsp2);
                    }
                    if (this.errors.size() > 0) {
                        result.add("Error occurred :");
                        result.addAll(this.errors);
                    } else if (diff == null || diff.size() == 0) {
                        result.add("None of the DCs are different");
                    } else {
                        result.add("The following DCs are different :");
                        result.addAll(diff);
                    }
                } else {
                    result.add("Unknown command '" + command + "'" + NEW_LINE + NEW_LINE + "Known commands are : ");
                    result.add("   diff <workspace1> <workspace2>");
                    result.add("      compare given workspaces");
                    result.add("   exit");
                    result.add("      exit shell");
                }
                result.add(PROMPT);
            }
            catch (Exception x) {
                result.clear();
                result.add(PROMPT);
            }
        }
        console.display(result);
        return quit;
    }

    private Collection dcDiff(String wsp1, String wsp2) {
        Collection diffs = new ArrayList();
        GetRequest req = new GetRequest("sysconfig/support/WorkspaceComparison");
        Query query = new Query();
        query.appendQueryParameter("leftWsp", wsp1);
        query.appendQueryParameter("rightWsp", wsp2);
        query.appendQueryParameter("presentInLeftOnly", "on");
        query.appendQueryParameter("presentInRightOnly", "on");
        query.appendQueryParameter("presentInBothDifferent", "on");
        query.appendQueryParameter("xmlOutput", "on");
        query.appendQueryParameter("command", "Compare");
        req.setQuery(query);
        try {
            IResponse resp = this.con.send((IRequest)req);
            int status = resp.getStatus();
            if (status == 200) {
                InputStream in = resp.getStream();
                this.saxParser = this.createXMLReader();
                if (this.saxParser != null) {
                    SaxHandler handler = new SaxHandler();
                    this.saxParser.setContentHandler((ContentHandler)((Object)handler));
                    InputSource s = new InputSource(in);
                    this.saxParser.parse(s);
                    diffs = handler.getDiff();
                    this.errors = handler.getErrors();
                }
            } else {
                String msg = "Request comparing workspaces " + wsp1 + " and " + wsp2 + " failed with HTTP request status " + status;
                this.errors.add(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return diffs;
    }

    public String getPrompt() {
        return PROMPT;
    }

    public boolean logon(Console console, String targetURL, String user, String password) {
        try {
            this.con = new Connection(targetURL);
            this.con.setSessionContext((ISessionContext)new SessionContext(user, password));
            OptionsRequest req = new OptionsRequest("ws");
            IResponse resp = this.con.send((IRequest)req);
            int status = resp.getStatus();
            if (status == 200) {
                console.display(user + " logged on to " + targetURL + " successfully" + NEW_LINE + PROMPT);
                return true;
            }
            console.display("logon of user " + user + " to " + targetURL + " failed with HTTP response status " + status);
            return false;
        }
        catch (Exception x) {
            return false;
        }
    }

    public boolean checkUrl(Console console, String targetURL) {
        try {
            this.con = new Connection(targetURL);
            return true;
        }
        catch (Exception x) {
            return false;
        }
    }

    private XMLReader createXMLReader() {
        if (this.saxParser == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    this.saxParser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
                    this.saxParser.setFeature("http://xml.org/sax/features/namespaces", true);
                }
                catch (SAXNotRecognizedException ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Selected XML parser does not support namespace handling", (Throwable)ex);
                }
                catch (SAXNotSupportedException ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Selected XML parser does not support namespace handling", (Throwable)ex);
                }
                catch (SAXException ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Unable to find or instantiate XML parser", (Throwable)ex);
                }
                catch (FactoryConfigurationError ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Failed to instantiate XML parser factory", (Throwable)ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new ParserException("VFS WebDAV/DeltaV handler: Unable to find or instantiate XML parser", (Throwable)ex);
                }
                Object var8_2 = null;
                Thread.currentThread().setContextClassLoader(cl);
            }
            catch (Throwable throwable) {
                Object var8_3 = null;
                Thread.currentThread().setContextClassLoader(cl);
                throw throwable;
            }
        }
        return this.saxParser;
    }
}

