/*
 * Decompiled with CFR 0.152.
 */
package dcnames;

import dcnames.Console;
import dcnames.Hider;
import dcnames.Interpreter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;

public final class ConsoleImpl
implements Console {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private Interpreter interpreter;
    private Hider hider;
    private BufferedReader stdin;
    private boolean unhiding;

    public static void main(String[] aArguments) {
        try {
            Class<?> theClass = Class.forName(aArguments[0]);
            Interpreter interpreter = (Interpreter)theClass.newInstance();
            ConsoleImpl console = new ConsoleImpl(interpreter);
            console.run();
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex + " Interpreter class must be in class path.");
        }
        catch (InstantiationException ex) {
            System.err.println(ex + " Interpreter class must be concrete.");
        }
        catch (IllegalAccessException ex) {
            System.err.println(ex + " Interpreter class must have a no-arg constructor.");
        }
    }

    public ConsoleImpl(Interpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException("Interpreter class cannot be null.");
        }
        this.interpreter = interpreter;
        this.unhiding = false;
    }

    public void hide(boolean hideInput) {
        this.unhiding = this.hider.hide(hideInput);
    }

    public void run() {
        this.stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            try {
                this.hider = new Hider();
                this.hider.start();
                this.logon();
                boolean quit = false;
                String line = null;
                while (!quit) {
                    do {
                        line = this.stdin.readLine();
                    } while (!this.hider.shortMomentGone);
                    quit = this.interpreter.parseInput(line, this);
                }
            }
            catch (IOException ex) {
                System.err.println(ex);
                Object var4_5 = null;
                this.shutdown(this.stdin);
            }
            Object var4_4 = null;
            this.shutdown(this.stdin);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.shutdown(this.stdin);
            throw throwable;
        }
    }

    private void logon() {
        String prompt = this.interpreter.getPrompt();
        boolean ok = false;
        try {
            while (!ok) {
                String targetURL = this.readLine(prompt + "Enter URL of DTR server :");
                ok = this.interpreter.checkUrl(this, targetURL);
                if (!ok) continue;
                String user = this.readLine(prompt + "Enter userID :");
                String pwd = this.readLine(prompt + "Enter password :", true);
                this.display("connecting ..." + NEW_LINE);
                ok = this.interpreter.logon(this, targetURL, user, pwd);
            }
        }
        catch (IOException x) {
            this.display(x.toString());
        }
    }

    private String readLine(String prompt) throws IOException {
        return this.readLine(prompt, false);
    }

    private String readLine(String prompt, boolean hide) throws IOException {
        String line;
        if (this.unhiding) {
            this.display(NEW_LINE);
        }
        this.display(prompt + " ");
        this.hide(hide);
        do {
            line = this.stdin.readLine();
        } while (!this.hider.shortMomentGone);
        this.hide(false);
        return line;
    }

    public void display(Object aText) {
        System.out.print(aText.toString());
        System.out.flush();
    }

    public void display(List aText) {
        Iterator it = aText.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            this.display(next);
            if (!it.hasNext()) continue;
            this.display(NEW_LINE);
        }
        it = aText.iterator();
        FileWriter writer = null;
        File tempFile = new File("C:\\temp");
        if (!tempFile.exists()) {
            tempFile.mkdir();
        }
        try {
            File file = new File("C:\\temp\\DcNames");
            writer = new FileWriter(file);
            if (writer != null) {
                while (it.hasNext()) {
                    Object next = it.next();
                    if (!it.hasNext()) continue;
                    this.displayToFile(writer, next);
                    this.displayToFile(writer, NEW_LINE);
                }
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void displayToFile(FileWriter writer, Object aText) throws IOException {
        writer.write(aText.toString());
    }

    private void shutdown(Reader aStdin) {
        try {
            aStdin.close();
            this.hider.terminate();
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }
}

